/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transactions;

import java.util.Iterator;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.neo4j.transactions.ApplicationConfig;
import org.springframework.data.neo4j.transactions.service.ServiceA;
import org.springframework.data.neo4j.transactions.service.ServiceB;
import org.springframework.data.neo4j.transactions.service.WrapperService;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(classes={ApplicationConfig.class})
@RunWith(value=SpringJUnit4ClassRunner.class)
public class ExtendedTransactionsTest
extends MultiDriverTestClass {
    @Autowired
    ServiceA serviceA;
    @Autowired
    ServiceB serviceB;
    @Autowired
    WrapperService wrapperService;

    @Before
    public void tearDown() {
        this.wrapperService.purge();
    }

    @Test
    public void shouldRollbackSuccessThenFail() {
        try {
            this.wrapperService.composeSuccessThenFail();
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Deliberately throwing exception", (Object)e.getLocalizedMessage());
            Assert.assertEquals((long)0L, (long)this.countNodes());
        }
    }

    @Test
    public void shouldCommitSuccessSuccess() {
        try {
            this.wrapperService.composeSuccessThenSuccess();
            Assert.assertEquals((long)2L, (long)this.countNodes());
        }
        catch (Exception e) {
            Assert.fail((String)"should not have thrown exception");
        }
    }

    @Test
    public void shouldRollbackFailThenSuccess() {
        try {
            this.wrapperService.composeFailThenSuccess();
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Deliberately throwing exception", (Object)e.getLocalizedMessage());
            Assert.assertEquals((long)0L, (long)this.countNodes());
        }
    }

    @Test
    public void shouldRollbackFailThenFail() {
        try {
            this.wrapperService.composeFailThenFail();
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Deliberately throwing exception", (Object)e.getLocalizedMessage());
            Assert.assertEquals((long)0L, (long)this.countNodes());
        }
    }

    @Test
    public void shouldRollbackWithCheckedException() {
        try {
            this.wrapperService.rollbackWithCheckedException();
            Assert.fail((String)"should have thrown exception");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Deliberately throwing exception", (Object)e.getLocalizedMessage());
            Assert.assertEquals((long)0L, (long)this.countNodes());
        }
    }

    @Test
    public void shouldRollbackRepositoryMethodOnCheckedException() {
        try {
            this.serviceA.run();
        }
        catch (Exception e) {
            Assert.assertNull((Object)this.serviceB.getBilbo());
        }
    }

    private int countNodes() {
        Iterator<Map<String, Object>> iterator = this.wrapperService.fetch().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }
}

