/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.config.Neo4jMappingContextFactoryBean;
import org.springframework.data.neo4j.repository.config.Neo4jOgmEntityInstantiatorConfigurationBean;
import org.springframework.data.neo4j.repository.support.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactoryBean;
import org.springframework.data.neo4j.transaction.SharedSessionCreator;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class Neo4jRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    static final String GENERATE_BEAN_NAME = "(generated)";
    static final String DEFAULT_SESSION_FACTORY_BEAN_NAME = "sessionFactory";
    static final String DEFAULT_TRANSACTION_MANAGER_BEAN_NAME = "transactionManager";
    private static final String ENTITY_INSTANTIATOR_CONFIGURATION_BEAN_NAME = "neo4jOgmEntityInstantiatorConfigurationBean";
    private static final String ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE = "enableDefaultTransactions";
    private static final String NEO4J_PERSISTENCE_EXCEPTION_TRANSLATOR_NAME = "neo4jPersistenceExceptionTranslator";
    private static final String MODULE_PREFIX = "neo4j";
    private static final String MODULE_NAME = "Neo4j";
    public static final boolean HAS_ENTITY_INSTANTIATOR_FEATURE = ClassUtils.isPresent((String)"org.neo4j.ogm.session.EntityInstantiator", (ClassLoader)Neo4jRepositoryConfigurationExtension.class.getClassLoader());
    private String sessionBeanName;
    private String neo4jMappingContextBeanName;

    public String getModuleName() {
        return MODULE_NAME;
    }

    public String getRepositoryFactoryBeanClassName() {
        return Neo4jRepositoryFactoryBean.class.getName();
    }

    protected String getModulePrefix() {
        return MODULE_PREFIX;
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Arrays.asList(NodeEntity.class, RelationshipEntity.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(Neo4jRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, RepositoryConfigurationSource source) {
        String transactionManagerRefPropertyName = "transactionManagerRef";
        String transactionManagerPropertyName = DEFAULT_TRANSACTION_MANAGER_BEAN_NAME;
        String mappingContextPropertyName = "mappingContext";
        String sessionPropertyName = "session";
        Optional transactionManagerRef = source.getAttribute(transactionManagerRefPropertyName);
        builder.addPropertyValue(transactionManagerPropertyName, (Object)transactionManagerRef.orElse(DEFAULT_TRANSACTION_MANAGER_BEAN_NAME));
        builder.addPropertyReference(sessionPropertyName, this.sessionBeanName);
        builder.addPropertyReference(mappingContextPropertyName, this.neo4jMappingContextBeanName);
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, (Object)attributes.getBoolean(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE));
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Optional enableDefaultTransactions = config.getAttribute(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE);
        if (enableDefaultTransactions.filter(StringUtils::hasText).isPresent()) {
            enableDefaultTransactions.ifPresent(value -> builder.addPropertyValue(ENABLE_DEFAULT_TRANSACTIONS_ATTRIBUTE, value));
        }
    }

    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource config) {
        super.registerBeansForRoot(registry, config);
        Object source = config.getSource();
        String configuredSessionBeanName = Optional.of("sessionBeanName").flatMap(arg_0 -> ((RepositoryConfigurationSource)config).getAttribute(arg_0)).orElse(GENERATE_BEAN_NAME);
        this.sessionBeanName = Neo4jRepositoryConfigurationExtension.registerWithGeneratedNameOrUseConfigured(Neo4jRepositoryConfigurationExtension.createSharedSessionCreatorBeanDefinition(config), registry, configuredSessionBeanName, source);
        String configuredMappingContextBeanName = Optional.of("mappingContextBeanName").flatMap(arg_0 -> ((RepositoryConfigurationSource)config).getAttribute(arg_0)).orElse(GENERATE_BEAN_NAME);
        this.neo4jMappingContextBeanName = Neo4jRepositoryConfigurationExtension.registerWithGeneratedNameOrUseConfigured(Neo4jRepositoryConfigurationExtension.createNeo4jMappingContextFactoryBeanDefinition(config), registry, configuredMappingContextBeanName, source);
        Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> new RootBeanDefinition(Neo4jPersistenceExceptionTranslator.class), (BeanDefinitionRegistry)registry, (String)NEO4J_PERSISTENCE_EXCEPTION_TRANSLATOR_NAME, (Object)source);
        if (HAS_ENTITY_INSTANTIATOR_FEATURE) {
            Supplier<AbstractBeanDefinition> rootBeanDefinition = () -> ((BeanDefinitionBuilder)BeanDefinitionBuilder.rootBeanDefinition(Neo4jOgmEntityInstantiatorConfigurationBean.class).setAutowireMode(2).addConstructorArgReference(Neo4jRepositoryConfigurationExtension.getSessionFactoryBeanName(config)).addConstructorArgReference(this.neo4jMappingContextBeanName)).getBeanDefinition();
            Neo4jRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(rootBeanDefinition, (BeanDefinitionRegistry)registry, (String)ENTITY_INSTANTIATOR_CONFIGURATION_BEAN_NAME, (Object)source);
        }
    }

    private static String registerWithGeneratedNameOrUseConfigured(AbstractBeanDefinition bean, BeanDefinitionRegistry registry, String configuredBeanName, Object source) {
        String registeredBeanName = configuredBeanName;
        if (GENERATE_BEAN_NAME.equals(configuredBeanName)) {
            registeredBeanName = Neo4jRepositoryConfigurationExtension.registerWithSourceAndGeneratedBeanName((AbstractBeanDefinition)bean, (BeanDefinitionRegistry)registry, (Object)source);
        } else {
            bean.setSource(source);
            registry.registerBeanDefinition(configuredBeanName, (BeanDefinition)bean);
        }
        return registeredBeanName;
    }

    private static AbstractBeanDefinition createSharedSessionCreatorBeanDefinition(RepositoryConfigurationSource config) {
        String sessionFactoryBeanName = Neo4jRepositoryConfigurationExtension.getSessionFactoryBeanName(config);
        AbstractBeanDefinition sharedSessionCreatorBeanDefinition = BeanDefinitionBuilder.rootBeanDefinition(SharedSessionCreator.class, (String)"createSharedSession").addConstructorArgReference(sessionFactoryBeanName).getBeanDefinition();
        sharedSessionCreatorBeanDefinition.addQualifier(new AutowireCandidateQualifier(Qualifier.class, (Object)sessionFactoryBeanName));
        return sharedSessionCreatorBeanDefinition;
    }

    private static AbstractBeanDefinition createNeo4jMappingContextFactoryBeanDefinition(RepositoryConfigurationSource config) {
        return BeanDefinitionBuilder.rootBeanDefinition(Neo4jMappingContextFactoryBean.class).addConstructorArgValue((Object)Neo4jRepositoryConfigurationExtension.getSessionFactoryBeanName(config)).getBeanDefinition();
    }

    private static String getSessionFactoryBeanName(RepositoryConfigurationSource config) {
        return Optional.of("sessionFactoryRef").flatMap(arg_0 -> ((RepositoryConfigurationSource)config).getAttribute(arg_0)).orElse(DEFAULT_SESSION_FACTORY_BEAN_NAME);
    }
}

