/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.UnaryOperator;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.springframework.data.neo4j.core.mapping.Constants;

final class DynamicLabels
implements UnaryOperator<StatementBuilder.OngoingMatchAndUpdate> {
    public static final DynamicLabels EMPTY = new DynamicLabels(Collections.emptyList(), Collections.emptyList());
    private static final Node rootNode = Cypher.anyNode((SymbolicName)Constants.NAME_OF_ROOT_NODE);
    private final List<String> oldLabels;
    private final List<String> newLabels;

    DynamicLabels(Collection<String> oldLabels, Collection<String> newLabels) {
        this.oldLabels = new ArrayList<String>(oldLabels);
        this.newLabels = new ArrayList<String>(newLabels);
    }

    @Override
    public StatementBuilder.OngoingMatchAndUpdate apply(StatementBuilder.OngoingMatchAndUpdate ongoingMatchAndUpdate) {
        StatementBuilder.OngoingMatchAndUpdate decoratedMatchAndUpdate = ongoingMatchAndUpdate;
        if (!this.oldLabels.isEmpty()) {
            decoratedMatchAndUpdate = decoratedMatchAndUpdate.remove(rootNode, this.oldLabels.toArray(new String[0]));
        }
        if (!this.newLabels.isEmpty()) {
            decoratedMatchAndUpdate = decoratedMatchAndUpdate.set(rootNode, this.newLabels.toArray(new String[0]));
        }
        return decoratedMatchAndUpdate;
    }
}

