/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.driver.Value;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.schema.CompositeProperty;
import org.springframework.data.neo4j.core.schema.DynamicLabels;
import org.springframework.data.neo4j.core.schema.RelationshipProperties;

@API(status=API.Status.STABLE, since="6.0")
public interface Neo4jPersistentProperty
extends PersistentProperty<Neo4jPersistentProperty>,
GraphPropertyDescription {
    default public boolean isDynamicAssociation() {
        return this.isAssociation() && this.isMap() && (this.getComponentType() == String.class || this.getComponentType().isEnum());
    }

    default public boolean isDynamicOneToManyAssociation() {
        return this.isDynamicAssociation() && this.getTypeInformation().getRequiredActualType().isCollectionLike();
    }

    default public boolean isDynamicLabels() {
        return this.isAnnotationPresent(DynamicLabels.class) && this.isCollectionLike();
    }

    @Deprecated
    default public boolean isRelationshipWithProperties() {
        return this.isAssociation() && this.isCollectionLike() && this.getActualType().isAnnotationPresent(RelationshipProperties.class);
    }

    public Function<Object, Value> getOptionalWritingConverter();

    public Function<Value, Object> getOptionalReadingConverter();

    @Deprecated
    default public boolean isEntityInRelationshipWithProperties() {
        return this.isEntityWithRelationshipProperties();
    }

    public boolean isEntityWithRelationshipProperties();

    default public String computePrefixWithDelimiter() {
        CompositeProperty compositeProperty = (CompositeProperty)this.getRequiredAnnotation(CompositeProperty.class);
        return Optional.of(compositeProperty.prefix()).map(String::trim).filter(s -> !s.isEmpty()).orElseGet(this::getFieldName) + compositeProperty.delimiter();
    }
}

