/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping.callback;

import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;

final class OptimisticLockingSupport {
    private final Neo4jMappingContext mappingContext;

    OptimisticLockingSupport(Neo4jMappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    Object getAndIncrementVersionPropertyIfNecessary(Object entity) {
        Neo4jPersistentEntity neo4jPersistentEntity = (Neo4jPersistentEntity)this.mappingContext.getRequiredNodeDescription(entity.getClass());
        if (!neo4jPersistentEntity.hasVersionProperty()) {
            return entity;
        }
        PersistentPropertyAccessor propertyAccessor = neo4jPersistentEntity.getPropertyAccessor(entity);
        Neo4jPersistentProperty versionProperty = (Neo4jPersistentProperty)neo4jPersistentEntity.getRequiredVersionProperty();
        if (!Long.class.isAssignableFrom(versionProperty.getType())) {
            return entity;
        }
        Long versionPropertyValue = (Long)propertyAccessor.getProperty((PersistentProperty)versionProperty);
        long newVersionValue = 0L;
        if (versionPropertyValue != null) {
            newVersionValue = versionPropertyValue + 1L;
        }
        propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)newVersionValue);
        return propertyAccessor.getBean();
    }
}

