/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Driver;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;

final class StartupLogger {
    private static final LogAccessor logger = new LogAccessor(LogFactory.getLog(StartupLogger.class));
    private final Mode mode;

    StartupLogger(Mode mode) {
        this.mode = mode;
    }

    void logStarting() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug(this::getStartingMessage);
    }

    String getStartingMessage() {
        StringBuilder sb = new StringBuilder();
        String sdnRx = this.getVersionOf(EnableNeo4jRepositories.class).map(v -> "SDN v" + v).orElse("an unknown version of SDN");
        String sdC = this.getVersionOf(AbstractMappingContext.class).map(v -> "Spring Data Commons v" + v).orElse("an unknown version of Spring Data Commons");
        String driver = this.getVersionOf(Driver.class).map(v -> "Neo4j Driver v" + v).orElse("an unknown version of the Neo4j Java Driver");
        sb.append("Bootstrapping ").append(this.mode.displayValue).append(" Neo4j repositories based on ").append(sdnRx).append(" with ").append(sdC).append(" and ").append(driver).append(".");
        return sb.toString();
    }

    private Optional<String> getVersionOf(Class<?> clazz) {
        return Optional.of(clazz).map(Class::getPackage).map(Package::getImplementationVersion).map(String::trim).filter(v -> !v.isEmpty());
    }

    static enum Mode {
        IMPERATIVE("imperative"),
        REACTIVE("reactive");

        final String displayValue;

        private Mode(String displayValue) {
            this.displayValue = displayValue;
        }
    }
}

