/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import org.apiguardian.api.API;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public final class NestedRelationshipProcessingStateMachine {
    private final StampedLock lock = new StampedLock();
    private final Neo4jMappingContext mappingContext;
    private final Set<RelationshipDescriptionWithSourceId> processedRelationshipDescriptions = new HashSet<RelationshipDescriptionWithSourceId>();
    private final Set<Object> processedObjects = new HashSet<Object>();
    private final Map<Object, Object> processedObjectsAlias = new HashMap<Object, Object>();
    private final Map<Object, Long> processedObjectsIds = new HashMap<Object, Long>();

    public NestedRelationshipProcessingStateMachine(Neo4jMappingContext mappingContext) {
        Assert.notNull((Object)mappingContext, (String)"Mapping context is required");
        this.mappingContext = mappingContext;
    }

    public NestedRelationshipProcessingStateMachine(Neo4jMappingContext mappingContext, Object initialObject, Long internalId) {
        this(mappingContext);
        Assert.notNull((Object)initialObject, (String)"Initial object must not be null.");
        Assert.notNull((Object)internalId, (String)"The initial objects internal ID must not be null.");
        this.processedObjects.add(initialObject);
        this.processedObjectsIds.put(initialObject, internalId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessState getStateOf(Object fromId, RelationshipDescription relationshipDescription, @Nullable Collection<?> valuesToStore) {
        long stamp = this.lock.readLock();
        try {
            boolean hasProcessedRelationship = this.hasProcessedRelationship(fromId, relationshipDescription);
            boolean hasProcessedAllValues = this.hasProcessedAllOf(valuesToStore);
            if (hasProcessedRelationship && hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_BOTH;
                return processState;
            }
            if (hasProcessedRelationship) {
                ProcessState processState = ProcessState.PROCESSED_ALL_RELATIONSHIPS;
                return processState;
            }
            if (hasProcessedAllValues) {
                ProcessState processState = ProcessState.PROCESSED_ALL_VALUES;
                return processState;
            }
            ProcessState processState = ProcessState.PROCESSED_NONE;
            return processState;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRelationshipAsProcessed(Object fromId, @Nullable RelationshipDescription relationshipDescription) {
        if (relationshipDescription == null) {
            return;
        }
        long stamp = this.lock.writeLock();
        try {
            this.processedRelationshipDescriptions.add(new RelationshipDescriptionWithSourceId(fromId, relationshipDescription));
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markValueAsProcessed(Object valueToStore, @Nullable Long internalId) {
        long stamp = this.lock.writeLock();
        try {
            this.doMarkValueAsProcessed(valueToStore, internalId);
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private void doMarkValueAsProcessed(Object valueToStore, Long internalId) {
        Object value = this.extractRelatedValueFromRelationshipProperties(valueToStore);
        this.processedObjects.add(valueToStore);
        this.processedObjects.add(value);
        if (internalId != null) {
            this.processedObjectsIds.put(valueToStore, internalId);
            this.processedObjectsIds.put(value, internalId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcessedValue(Object value) {
        long stamp = this.lock.readLock();
        try {
            Object valueToCheck = this.extractRelatedValueFromRelationshipProperties(value);
            boolean processed = this.processedObjects.contains(valueToCheck) || this.processedObjectsAlias.containsKey(valueToCheck);
            Class<?> typeOfValue = valueToCheck.getClass();
            if (!processed && this.mappingContext.hasPersistentEntityFor(typeOfValue)) {
                Optional alreadyProcessedObject;
                Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeOfValue);
                Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entity.getIdProperty();
                Object id = idProperty == null ? null : entity.getPropertyAccessor(valueToCheck).getProperty((PersistentProperty)idProperty);
                Optional<Object> optional = alreadyProcessedObject = id == null ? Optional.empty() : this.processedObjects.stream().filter(typeOfValue::isInstance).filter(processedObject -> id.equals(entity.getPropertyAccessor(processedObject).getProperty((PersistentProperty)idProperty))).findAny();
                if (alreadyProcessedObject.isPresent()) {
                    processed = true;
                    Long internalId = this.getInternalId(alreadyProcessedObject.get());
                    stamp = this.lock.tryConvertToWriteLock(stamp);
                    this.doMarkValueAsProcessed(valueToCheck, internalId);
                }
            }
            boolean bl = processed;
            return bl;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProcessedRelationship(Object fromId, @Nullable RelationshipDescription relationshipDescription) {
        if (relationshipDescription != null) {
            long stamp = this.lock.readLock();
            try {
                boolean bl = this.processedRelationshipDescriptions.contains(new RelationshipDescriptionWithSourceId(fromId, relationshipDescription));
                return bl;
            }
            finally {
                this.lock.unlock(stamp);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markValueAsProcessedAs(Object valueToStore, Object bean) {
        long stamp = this.lock.writeLock();
        try {
            this.processedObjectsAlias.put(valueToStore, bean);
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Long getInternalId(Object object) {
        long stamp = this.lock.readLock();
        try {
            Object valueToCheck = this.extractRelatedValueFromRelationshipProperties(object);
            Long possibleId = this.processedObjectsIds.get(valueToCheck);
            Long l = possibleId != null ? possibleId : this.processedObjectsIds.get(this.processedObjectsAlias.get(valueToCheck));
            return l;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProcessedAs(Object entity) {
        long stamp = this.lock.readLock();
        try {
            Object object = this.processedObjectsAlias.getOrDefault(entity, entity);
            return object;
        }
        finally {
            this.lock.unlock(stamp);
        }
    }

    private boolean hasProcessedAllOf(@Nullable Collection<?> valuesToStore) {
        if (valuesToStore == null) {
            return false;
        }
        return this.processedObjects.containsAll(valuesToStore);
    }

    @NonNull
    private Object extractRelatedValueFromRelationshipProperties(Object valueToStore) {
        Object value = valueToStore instanceof MappingSupport.RelationshipPropertiesWithEntityHolder ? ((MappingSupport.RelationshipPropertiesWithEntityHolder)valueToStore).getRelatedEntity() : valueToStore;
        return value;
    }

    private static class RelationshipDescriptionWithSourceId {
        private final Object id;
        private final RelationshipDescription relationshipDescription;

        RelationshipDescriptionWithSourceId(Object id, RelationshipDescription relationshipDescription) {
            this.id = id;
            this.relationshipDescription = relationshipDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RelationshipDescriptionWithSourceId that = (RelationshipDescriptionWithSourceId)o;
            return this.id.equals(that.id) && this.relationshipDescription.equals(that.relationshipDescription);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.relationshipDescription);
        }
    }

    public static enum ProcessState {
        PROCESSED_NONE,
        PROCESSED_BOTH,
        PROCESSED_ALL_RELATIONSHIPS,
        PROCESSED_ALL_VALUES;

    }
}

