/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.lang.invoke.LambdaMetafactory;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.logging.LogFactory;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.NoSuchRecordException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.core.log.LogAccessor;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.neo4j.core.DatabaseSelectionProvider;
import org.springframework.data.neo4j.core.DynamicLabels;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.FluentNeo4jOperations;
import org.springframework.data.neo4j.core.FluentOperationSupport;
import org.springframework.data.neo4j.core.FluentSaveOperation;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.PropertyFilterSupport;
import org.springframework.data.neo4j.core.PropertyPathWalkStep;
import org.springframework.data.neo4j.core.RelationshipHandler;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.core.mapping.AssociationHandlerSupport;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.DtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityFromDtoInstantiatingConverter;
import org.springframework.data.neo4j.core.mapping.EntityInstanceWithSource;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipProcessingStateMachine;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.mapping.callback.EventSupport;
import org.springframework.data.neo4j.core.schema.TargetNode;
import org.springframework.data.neo4j.repository.NoResultException;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.ProjectionInformation;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jTemplate
implements Neo4jOperations,
FluentNeo4jOperations,
BeanClassLoaderAware,
BeanFactoryAware {
    private static final LogAccessor log = new LogAccessor(LogFactory.getLog(Neo4jTemplate.class));
    private static final String OPTIMISTIC_LOCKING_ERROR_MESSAGE = "An entity with the required version does not exist.";
    private final Neo4jClient neo4jClient;
    private final Neo4jMappingContext neo4jMappingContext;
    private final CypherGenerator cypherGenerator;
    private ClassLoader beanClassLoader;
    private EventSupport eventSupport;
    private ProjectionFactory projectionFactory;
    private Renderer renderer;

    @Deprecated
    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseSelectionProvider) {
        this(neo4jClient, neo4jMappingContext, EntityCallbacks.create());
        if (!Objects.equals(databaseSelectionProvider, neo4jClient.getDatabaseSelectionProvider())) {
            throw new IllegalStateException("The provided database selection provider differs from the Neo4jClient's one.");
        }
    }

    @Deprecated
    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, DatabaseSelectionProvider databaseSelectionProvider, EntityCallbacks entityCallbacks) {
        this(neo4jClient, neo4jMappingContext, entityCallbacks);
        if (!Objects.equals(databaseSelectionProvider, neo4jClient.getDatabaseSelectionProvider())) {
            throw new IllegalStateException("The provided database selection provider differs from the Neo4jClient's one.");
        }
    }

    public Neo4jTemplate(Neo4jClient neo4jClient) {
        this(neo4jClient, new Neo4jMappingContext());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext) {
        this(neo4jClient, neo4jMappingContext, EntityCallbacks.create());
    }

    public Neo4jTemplate(Neo4jClient neo4jClient, Neo4jMappingContext neo4jMappingContext, EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)neo4jClient, (String)"The Neo4jClient is required");
        Assert.notNull((Object)neo4jMappingContext, (String)"The Neo4jMappingContext is required");
        this.neo4jClient = neo4jClient;
        this.neo4jMappingContext = neo4jMappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
        this.eventSupport = EventSupport.useExistingCallbacks(neo4jMappingContext, entityCallbacks);
    }

    @Override
    public long count(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.count(statement);
    }

    @Override
    public long count(Statement statement) {
        return this.count(statement, Collections.emptyMap());
    }

    @Override
    public long count(Statement statement, Map<String, Object> parameters) {
        return this.count(this.renderer.render(statement), TemplateSupport.mergeParameters(statement, parameters));
    }

    @Override
    public long count(String cypherQuery) {
        return this.count(cypherQuery, Collections.emptyMap());
    }

    @Override
    public long count(String cypherQuery, Map<String, Object> parameters) {
        PreparedQuery<Long> preparedQuery = PreparedQuery.queryFor(Long.class).withCypherQuery(cypherQuery).withParameters(parameters).build();
        return this.toExecutableQuery(preparedQuery).getRequiredSingleResult();
    }

    @Override
    public <T> List<T> findAll(Class<T> domainType) {
        return this.doFindAll(domainType, null);
    }

    private <T> List<T> doFindAll(Class<T> domainType, @Nullable Class<?> resultType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, resultType, QueryFragmentsAndParameters.forFindAll(entityMetaData)).getResults();
    }

    @Override
    public <T> List<T> findAll(Statement statement, Class<T> domainType) {
        return this.createExecutableQuery(domainType, statement).getResults();
    }

    @Override
    public <T> List<T> findAll(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, statement, parameters).getResults();
    }

    @Override
    public <T> Optional<T> findOne(Statement statement, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, statement, parameters).getSingleResult();
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Class<T> domainType) {
        return this.createExecutableQuery(domainType, cypherQuery).getResults();
    }

    @Override
    public <T> List<T> findAll(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, cypherQuery, parameters).getResults();
    }

    @Override
    public <T> Optional<T> findOne(String cypherQuery, Map<String, Object> parameters, Class<T> domainType) {
        return this.createExecutableQuery(domainType, null, cypherQuery, parameters).getSingleResult();
    }

    @Override
    public <T> FluentFindOperation.ExecutableFind<T> find(Class<T> domainType) {
        return new FluentOperationSupport(this).find(domainType);
    }

    <T, R> List<R> doFind(@Nullable String cypherQuery, @Nullable Map<String, Object> parameters, Class<T> domainType, Class<R> resultType, TemplateSupport.FetchType fetchType, @Nullable QueryFragmentsAndParameters queryFragmentsAndParameters) {
        List intermediaResults = Collections.emptyList();
        if (cypherQuery == null && queryFragmentsAndParameters == null && fetchType == TemplateSupport.FetchType.ALL) {
            intermediaResults = this.doFindAll(domainType, resultType);
        } else {
            Neo4jOperations.ExecutableQuery<T> executableQuery = queryFragmentsAndParameters == null ? this.createExecutableQuery(domainType, resultType, cypherQuery, parameters == null ? Collections.emptyMap() : parameters) : this.createExecutableQuery(domainType, resultType, queryFragmentsAndParameters);
            switch (fetchType) {
                case ALL: {
                    intermediaResults = executableQuery.getResults();
                    break;
                }
                case ONE: {
                    intermediaResults = executableQuery.getSingleResult().map(Collections::singletonList).orElseGet(Collections::emptyList);
                }
            }
        }
        if (resultType.isAssignableFrom(domainType)) {
            return intermediaResults;
        }
        if (resultType.isInterface()) {
            return intermediaResults.stream().map(instance -> this.projectionFactory.createProjection(resultType, instance)).collect(Collectors.toList());
        }
        DtoInstantiatingConverter converter = new DtoInstantiatingConverter(resultType, this.neo4jMappingContext);
        return intermediaResults.stream().map(EntityInstanceWithSource.class::cast).map(converter::convert).map(v -> v).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        Map<String, Object> parameters;
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        QueryFragmentsAndParameters fragmentsAndParameters = QueryFragmentsAndParameters.forExistsById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        Statement statement = fragmentsAndParameters.getQueryFragments().toStatement();
        return this.count(statement, parameters = fragmentsAndParameters.getParameters()) > 0L;
    }

    @Override
    public <T> Optional<T> findById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, null, QueryFragmentsAndParameters.forFindById(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id))).getSingleResult();
    }

    @Override
    public <T> List<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        return this.createExecutableQuery(domainType, null, QueryFragmentsAndParameters.forFindByAllId(entityMetaData, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids))).getResults();
    }

    private Object convertIdValues(@Nullable Neo4jPersistentProperty idProperty, Object idValues) {
        if (idProperty != null && ((Neo4jPersistentEntity)idProperty.getOwner()).isUsingInternalIds()) {
            return idValues;
        }
        return this.neo4jMappingContext.getConversionService().writeValue(idValues, (TypeInformation<?>)ClassTypeInformation.from(idValues.getClass()), idProperty == null ? null : idProperty.getOptionalConverter());
    }

    @Override
    public <T> T save(T instance) {
        return this.saveImpl(instance, Collections.emptySet(), null);
    }

    @Override
    public <T> T saveAs(T instance, BiPredicate<PropertyPath, Neo4jPersistentProperty> includeProperty) {
        if (instance == null) {
            return null;
        }
        return this.saveImpl(instance, TemplateSupport.computeIncludedPropertiesFromPredicate(this.neo4jMappingContext, instance.getClass(), includeProperty), null);
    }

    @Override
    public <T, R> R saveAs(T instance, Class<R> resultType) {
        Assert.notNull(resultType, (String)"ResultType must not be null!");
        if (instance == null) {
            return null;
        }
        if (resultType.equals(instance.getClass())) {
            return resultType.cast(this.save(instance));
        }
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(resultType);
        Collection<PropertyFilter.ProjectedPath> pps = PropertyFilterSupport.addPropertiesFrom(instance.getClass(), resultType, this.projectionFactory, this.neo4jMappingContext);
        T savedInstance = this.saveImpl(instance, pps, null);
        if (projectionInformation.isClosed()) {
            return (R)this.projectionFactory.createProjection(resultType, savedInstance);
        }
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(savedInstance.getClass());
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getIdProperty();
        PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(savedInstance);
        return (R)this.projectionFactory.createProjection(resultType, this.findById(propertyAccessor.getProperty((PersistentProperty)idProperty), savedInstance.getClass()).get());
    }

    private <T> T saveImpl(T instance, @Nullable Collection<PropertyFilter.ProjectedPath> includedProperties, @Nullable NestedRelationshipProcessingStateMachine stateMachine) {
        if (stateMachine != null && stateMachine.hasProcessedValue(instance)) {
            return instance;
        }
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(instance.getClass());
        boolean isEntityNew = entityMetaData.isNew(instance);
        T entityToBeSaved = this.eventSupport.maybeCallBeforeBind(instance);
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entityToBeSaved, entityMetaData);
        TemplateSupport.FilteredBinderFunction binderFunction = TemplateSupport.createAndApplyPropertyFilter(includedProperties, entityMetaData, this.neo4jMappingContext.getRequiredBinderFunctionFor(entityToBeSaved.getClass()));
        Optional newOrUpdatedNode = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.prepareSaveOf(entityMetaData, dynamicLabels))).bind(entityToBeSaved).with(binderFunction)).fetchAs(Entity.class).one();
        if (!newOrUpdatedNode.isPresent()) {
            if (entityMetaData.hasVersionProperty()) {
                throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
            }
            throw new IllegalStateException("Could not retrieve an internal id while saving.");
        }
        Long internalId = ((Entity)newOrUpdatedNode.get()).id();
        PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
        if (entityMetaData.isUsingInternalIds()) {
            propertyAccessor.setProperty(entityMetaData.getRequiredIdProperty(), (Object)internalId);
        }
        TemplateSupport.updateVersionPropertyIfPossible(entityMetaData, propertyAccessor, (Entity)newOrUpdatedNode.get());
        if (stateMachine == null) {
            stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext, instance, internalId);
        }
        stateMachine.markValueAsProcessed(instance, internalId);
        this.processRelations(entityMetaData, propertyAccessor, isEntityNew, stateMachine, binderFunction.filter);
        Object bean = propertyAccessor.getBean();
        stateMachine.markValueAsProcessedAs(instance, bean);
        return (T)bean;
    }

    private <T> DynamicLabels determineDynamicLabels(T entityToBeSaved, Neo4jPersistentEntity<?> entityMetaData) {
        return entityMetaData.getDynamicLabelsProperty().map(p -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(entityToBeSaved);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            Neo4jClient.RunnableSpec runnableQuery = (Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.createStatementReturningDynamicLabels(entityMetaData))).bind(this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty))).to("__id__")).bind(entityMetaData.getStaticLabels()).to("__staticLabels__");
            if (entityMetaData.hasVersionProperty()) {
                runnableQuery = (Neo4jClient.RunnableSpec)runnableQuery.bind((Long)propertyAccessor.getProperty(entityMetaData.getRequiredVersionProperty())).to("__version__");
            }
            Optional<Map<String, Object>> optionalResult = runnableQuery.fetch().one();
            return new DynamicLabels(entityMetaData, optionalResult.map(r -> (Collection)r.get("__nodeLabels__")).orElseGet(Collections::emptyList), (Collection)propertyAccessor.getProperty((PersistentProperty)p));
        }).orElse(DynamicLabels.EMPTY);
    }

    @Override
    public <T> List<T> saveAll(Iterable<T> instances) {
        return this.saveAllImpl(instances, Collections.emptySet(), null);
    }

    private <T> List<T> saveAllImpl(Iterable<T> instances, @Nullable Collection<PropertyFilter.ProjectedPath> includedProperties, @Nullable BiPredicate<PropertyPath, Neo4jPersistentProperty> includeProperty) {
        class Tuple3<T> {
            final T originalInstance;
            final boolean wasNew;
            final T modifiedInstance;

            Tuple3(T originalInstance, boolean wasNew, T modifiedInstance) {
                this.originalInstance = originalInstance;
                this.wasNew = wasNew;
                this.modifiedInstance = modifiedInstance;
            }
        }
        HashSet types = new HashSet();
        ArrayList entities = new ArrayList();
        instances.forEach(instance -> {
            entities.add(instance);
            types.add(instance.getClass());
        });
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        boolean heterogeneousCollection = types.size() > 1;
        Class domainClass = (Class)types.iterator().next();
        Collection<PropertyFilter.ProjectedPath> pps = includeProperty == null ? includedProperties : TemplateSupport.computeIncludedPropertiesFromPredicate(this.neo4jMappingContext, domainClass, includeProperty);
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainClass);
        if (heterogeneousCollection || entityMetaData.isUsingInternalIds() || entityMetaData.hasVersionProperty() || entityMetaData.getDynamicLabelsProperty().isPresent()) {
            log.debug((CharSequence)"Saving entities using single statements.");
            NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext);
            return entities.stream().map(e -> this.saveImpl(e, pps, stateMachine)).collect(Collectors.toList());
        }
        List entitiesToBeSaved = entities.stream().map(e -> new Tuple3<Object>(e, entityMetaData.isNew(e), this.eventSupport.maybeCallBeforeBind(e))).collect(Collectors.toList());
        TemplateSupport.FilteredBinderFunction binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(domainClass);
        binderFunction = TemplateSupport.createAndApplyPropertyFilter(pps, entityMetaData, binderFunction);
        List entityList = entitiesToBeSaved.stream().map(h -> h.modifiedInstance).map(binderFunction).collect(Collectors.toList());
        Map<Value, Long> idToInternalIdMapping = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.prepareSaveOfMultipleInstancesOf(entityMetaData))).bind(entityList).to("__entities__")).fetchAs(Map.Entry.class).mappedBy((t, r) -> new AbstractMap.SimpleEntry<Value, Long>(r.get("__id__"), r.get("__internalNeo4jId__").asLong())).all().stream().collect(Collectors.toMap(m -> (Value)m.getKey(), m -> (Long)m.getValue()));
        return entitiesToBeSaved.stream().map(t -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(t.modifiedInstance);
            Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty();
            Object id = this.convertIdValues(idProperty, propertyAccessor.getProperty((PersistentProperty)idProperty));
            Long internalId = (Long)idToInternalIdMapping.get(id);
            return this.processRelations(entityMetaData, propertyAccessor, t.wasNew, new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext, t.originalInstance, internalId), TemplateSupport.computeIncludePropertyPredicate(pps, entityMetaData));
        }).collect(Collectors.toList());
    }

    @Override
    public <T> List<T> saveAllAs(Iterable<T> instances, BiPredicate<PropertyPath, Neo4jPersistentProperty> includeProperty) {
        return this.saveAllImpl(instances, null, includeProperty);
    }

    @Override
    public <T, R> List<R> saveAllAs(Iterable<T> instances, Class<R> resultType) {
        Assert.notNull(resultType, (String)"ResultType must not be null!");
        Class<?> commonElementType = TemplateSupport.findCommonElementType(instances);
        if (commonElementType == null) {
            throw new IllegalArgumentException("Could not determine a common element of an heterogeneous collection.");
        }
        if (commonElementType == TemplateSupport.EmptyIterable.class) {
            return Collections.emptyList();
        }
        if (resultType.isAssignableFrom(commonElementType)) {
            List<T> saveElements = this.saveAll(instances);
            return saveElements;
        }
        ProjectionInformation projectionInformation = this.projectionFactory.getProjectionInformation(resultType);
        Collection<PropertyFilter.ProjectedPath> pps = PropertyFilterSupport.addPropertiesFrom(commonElementType, resultType, this.projectionFactory, this.neo4jMappingContext);
        List<T> savedInstances = this.saveAllImpl(instances, pps, null);
        if (projectionInformation.isClosed()) {
            return savedInstances.stream().map(instance -> this.projectionFactory.createProjection(resultType, instance)).collect(Collectors.toList());
        }
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(commonElementType);
        Neo4jPersistentProperty idProperty = (Neo4jPersistentProperty)entityMetaData.getIdProperty();
        List ids = savedInstances.stream().map(savedInstance -> {
            PersistentPropertyAccessor propertyAccessor = entityMetaData.getPropertyAccessor(savedInstance);
            return propertyAccessor.getProperty((PersistentProperty)idProperty);
        }).collect(Collectors.toList());
        return this.findAllById(ids, commonElementType).stream().map(instance -> this.projectionFactory.createProjection(resultType, instance)).collect(Collectors.toList());
    }

    @Override
    public <T> void deleteById(Object id, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        String nameOfParameter = "id";
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter));
        log.debug(() -> String.format("Deleting entity with id %s ", id));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        ResultSummary summary = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statement)).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id)).to(nameOfParameter)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    @Override
    public <T> void deleteByIdWithVersion(Object id, Class<T> domainType, Neo4jPersistentProperty versionProperty, Object versionValue) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        String nameOfParameter = "id";
        Condition condition = entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)nameOfParameter)).and(Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData)), (String[])new String[]{versionProperty.getPropertyName()}).isEqualTo((Expression)Cypher.parameter((String)"__version__")).or(Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData)), (String[])new String[]{versionProperty.getPropertyName()}).isNull()));
        Statement statement = this.cypherGenerator.prepareMatchOf(entityMetaData, condition).returning(new Expression[]{(Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData)}).build();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(nameOfParameter, this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), id));
        parameters.put("__version__", versionValue);
        this.createExecutableQuery(domainType, null, statement, parameters).getSingleResult().orElseThrow(() -> new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE));
        this.deleteById(id, domainType);
    }

    @Override
    public <T> void deleteAllById(Iterable<?> ids, Class<T> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        String nameOfParameter = "ids";
        Condition condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)nameOfParameter));
        log.debug(() -> String.format("Deleting all entities with the following ids: %s ", ids));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData, condition);
        ResultSummary summary = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statement)).bind(this.convertIdValues((Neo4jPersistentProperty)entityMetaData.getRequiredIdProperty(), ids)).to(nameOfParameter)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    @Override
    public void deleteAll(Class<?> domainType) {
        Neo4jPersistentEntity entityMetaData = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(domainType);
        log.debug(() -> String.format("Deleting all nodes with primary label %s", entityMetaData.getPrimaryLabel()));
        Statement statement = this.cypherGenerator.prepareDeleteOf(entityMetaData);
        ResultSummary summary = this.neo4jClient.query(this.renderer.render(statement)).run();
        log.debug(() -> String.format("Deleted %d nodes and %d relationships.", summary.counters().nodesDeleted(), summary.counters().relationshipsDeleted()));
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, Statement statement) {
        return this.createExecutableQuery(domainType, null, statement, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, String cypherQuery) {
        return this.createExecutableQuery(domainType, null, cypherQuery, Collections.emptyMap());
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, Statement statement, Map<String, Object> parameters) {
        return this.createExecutableQuery(domainType, resultType, this.renderer.render(statement), TemplateSupport.mergeParameters(statement, parameters));
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, @Nullable String cypherStatement, Map<String, Object> parameters) {
        Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction = TemplateSupport.getAndDecorateMappingFunction(this.neo4jMappingContext, domainType, resultType);
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withCypherQuery(cypherStatement).withParameters(parameters).usingMappingFunction(mappingFunction).build();
        return this.toExecutableQuery(preparedQuery);
    }

    private <T> T processRelations(Neo4jPersistentEntity<?> neo4jPersistentEntity, PersistentPropertyAccessor<?> parentPropertyAccessor, boolean isParentObjectNew, NestedRelationshipProcessingStateMachine stateMachine, PropertyFilter includeProperty) {
        PropertyFilter.RelaxedPropertyPath startingPropertyPath = PropertyFilter.RelaxedPropertyPath.withRootType(neo4jPersistentEntity.getUnderlyingClass());
        return this.processNestedRelations(neo4jPersistentEntity, parentPropertyAccessor, isParentObjectNew, stateMachine, includeProperty, startingPropertyPath);
    }

    private <T> T processNestedRelations(Neo4jPersistentEntity<?> sourceEntity, PersistentPropertyAccessor<?> propertyAccessor, boolean isParentObjectNew, NestedRelationshipProcessingStateMachine stateMachine, PropertyFilter includeProperty, PropertyFilter.RelaxedPropertyPath previousPath) {
        Object fromId = propertyAccessor.getProperty(sourceEntity.getRequiredIdProperty());
        AssociationHandlerSupport.of(sourceEntity).doWithAssociations((AssociationHandler<Neo4jPersistentProperty>)((AssociationHandler)association -> {
            CreateRelationshipStatementHolder statementHolder;
            Neo4jPersistentProperty idProperty;
            NestedRelationshipContext relationshipContext = NestedRelationshipContext.of((Association<Neo4jPersistentProperty>)association, propertyAccessor, sourceEntity);
            if (relationshipContext.isReadOnly()) {
                return;
            }
            Object rawValue = relationshipContext.getValue();
            Collection<?> relatedValuesToStore = MappingSupport.unifyRelationshipValue(relationshipContext.getInverse(), rawValue);
            RelationshipDescription relationshipDescription = relationshipContext.getRelationship();
            PropertyFilter.RelaxedPropertyPath currentPropertyPath = previousPath.append(relationshipDescription.getFieldName());
            if (!includeProperty.isNotFiltering() && !includeProperty.contains(currentPropertyPath)) {
                return;
            }
            if (!relationshipDescription.hasInternalIdProperty()) {
                idProperty = null;
            } else {
                Neo4jPersistentEntity relationshipPropertiesEntity = (Neo4jPersistentEntity)relationshipDescription.getRelationshipPropertiesEntity();
                idProperty = (Neo4jPersistentProperty)relationshipPropertiesEntity.getIdProperty();
            }
            NestedRelationshipProcessingStateMachine.ProcessState processState = stateMachine.getStateOf(fromId, relationshipDescription, relatedValuesToStore);
            if (processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_RELATIONSHIPS || processState == NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_BOTH) {
                return;
            }
            if (!isParentObjectNew && !stateMachine.hasProcessedRelationship(fromId, relationshipDescription)) {
                ArrayList<Long> knownRelationshipsIds = new ArrayList<Long>();
                if (idProperty != null) {
                    for (Object relatedValueToStore : relatedValuesToStore) {
                        Long id;
                        if (relatedValueToStore == null || (id = (Long)relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty)) == null) continue;
                        knownRelationshipsIds.add(id);
                    }
                }
                Statement relationshipRemoveQuery = this.cypherGenerator.prepareDeleteOf(sourceEntity, relationshipDescription);
                ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(relationshipRemoveQuery)).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getIdProperty(), fromId)).to("fromId")).bind(knownRelationshipsIds).to("__knownRelationShipIds__")).run();
            }
            if (relationshipContext.inverseValueIsEmpty()) {
                return;
            }
            stateMachine.markRelationshipAsProcessed(fromId, relationshipDescription);
            Neo4jPersistentProperty relationshipProperty = (Neo4jPersistentProperty)association.getInverse();
            RelationshipHandler relationshipHandler = RelationshipHandler.forProperty(relationshipProperty, rawValue);
            ArrayList<Object> plainRelationshipRows = new ArrayList<Object>();
            ArrayList<Map<String, Object>> relationshipPropertiesRows = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> newRelationshipPropertiesRows = new ArrayList<Map<String, Object>>();
            ArrayList updateRelatedValuesToStore = new ArrayList();
            ArrayList newRelatedValuesToStore = new ArrayList();
            for (Object relatedValueToStore : relatedValuesToStore) {
                boolean isNewRelationship;
                Long relatedInternalId;
                Object relatedObjectBeforeCallbacksApplied = relationshipContext.identifyAndExtractRelationshipTargetNode(relatedValueToStore);
                Neo4jPersistentEntity targetEntity = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(relatedObjectBeforeCallbacksApplied.getClass());
                boolean isEntityNew = targetEntity.isNew(relatedObjectBeforeCallbacksApplied);
                Object newRelatedObject = stateMachine.hasProcessedValue(relatedObjectBeforeCallbacksApplied) ? stateMachine.getProcessedAs(relatedObjectBeforeCallbacksApplied) : this.eventSupport.maybeCallBeforeBind(relatedObjectBeforeCallbacksApplied);
                Entity savedEntity = null;
                if (stateMachine.hasProcessedValue(relatedValueToStore)) {
                    relatedInternalId = stateMachine.getInternalId(relatedValueToStore);
                } else {
                    savedEntity = this.saveRelatedNode(newRelatedObject, targetEntity, includeProperty, currentPropertyPath);
                    relatedInternalId = savedEntity.id();
                    stateMachine.markValueAsProcessed(relatedValueToStore, relatedInternalId);
                    if (relatedValueToStore instanceof MappingSupport.RelationshipPropertiesWithEntityHolder) {
                        Object entity = ((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValueToStore).getRelatedEntity();
                        stateMachine.markValueAsProcessedAs(entity, relatedInternalId);
                    }
                }
                Neo4jPersistentProperty requiredIdProperty = (Neo4jPersistentProperty)targetEntity.getRequiredIdProperty();
                PersistentPropertyAccessor targetPropertyAccessor = targetEntity.getPropertyAccessor(newRelatedObject);
                Object actualRelatedId = targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
                if (targetEntity.isUsingInternalIds()) {
                    if (relatedInternalId == null && actualRelatedId != null) {
                        relatedInternalId = (Long)targetPropertyAccessor.getProperty((PersistentProperty)requiredIdProperty);
                    } else if (actualRelatedId == null) {
                        targetPropertyAccessor.setProperty((PersistentProperty)requiredIdProperty, (Object)relatedInternalId);
                    }
                }
                if (savedEntity != null) {
                    TemplateSupport.updateVersionPropertyIfPossible(targetEntity, targetPropertyAccessor, savedEntity);
                }
                stateMachine.markValueAsProcessedAs(relatedObjectBeforeCallbacksApplied, targetPropertyAccessor.getBean());
                stateMachine.markRelationshipAsProcessed(actualRelatedId == null ? relatedInternalId : actualRelatedId, relationshipDescription.getRelationshipObverse());
                Object idValue = idProperty != null ? relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).getProperty((PersistentProperty)idProperty) : null;
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("fromId", this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId));
                properties.put("toId", relatedInternalId);
                properties.put("__knownRelationShipId__", idValue);
                boolean bl = isNewRelationship = idValue == null;
                if (relationshipDescription.isDynamic()) {
                    List row;
                    CreateRelationshipStatementHolder statementHolder2;
                    if (relationshipDescription.hasRelationshipProperties() && isNewRelationship && idProperty != null) {
                        statementHolder2 = this.neo4jMappingContext.createStatementForSingleRelationship(sourceEntity, relationshipDescription, relatedValueToStore, true);
                        row = Collections.singletonList(properties);
                        statementHolder2 = statementHolder2.addProperty("__relationships__", row);
                        Optional relationshipInternalId = ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder2.getStatement())).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder2.getProperties())).fetchAs(Long.class).one();
                        this.assignIdToRelationshipProperties(relationshipContext, relatedValueToStore, idProperty, (Long)relationshipInternalId.get());
                    } else {
                        statementHolder2 = this.neo4jMappingContext.createStatementForSingleRelationship(sourceEntity, relationshipDescription, relatedValueToStore, false);
                        row = Collections.singletonList(properties);
                        statementHolder2 = statementHolder2.addProperty("__relationships__", row);
                        ((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder2.getStatement())).bind(this.convertIdValues((Neo4jPersistentProperty)sourceEntity.getRequiredIdProperty(), fromId)).to("fromId")).bind(relatedInternalId).to("toId")).bind(idValue).to("__knownRelationShipId__")).bindAll(statementHolder2.getProperties())).run();
                    }
                } else if (relationshipDescription.hasRelationshipProperties() && isNewRelationship && idProperty != null) {
                    newRelationshipPropertiesRows.add(properties);
                    newRelatedValuesToStore.add(relatedValueToStore);
                } else if (relationshipDescription.hasRelationshipProperties()) {
                    this.neo4jMappingContext.getEntityConverter().write(((MappingSupport.RelationshipPropertiesWithEntityHolder)relatedValueToStore).getRelationshipProperties(), properties);
                    relationshipPropertiesRows.add(properties);
                } else {
                    plainRelationshipRows.add(properties);
                }
                if (processState != NestedRelationshipProcessingStateMachine.ProcessState.PROCESSED_ALL_VALUES) {
                    this.processNestedRelations(targetEntity, targetPropertyAccessor, isEntityNew, stateMachine, includeProperty, currentPropertyPath);
                }
                Object potentiallyRecreatedNewRelatedObject = MappingSupport.getRelationshipOrRelationshipPropertiesObject(this.neo4jMappingContext, relationshipDescription.hasRelationshipProperties(), relationshipProperty.isDynamicAssociation(), relatedValueToStore, targetPropertyAccessor);
                relationshipHandler.handle(relatedValueToStore, relatedObjectBeforeCallbacksApplied, potentiallyRecreatedNewRelatedObject);
            }
            if (!(relationshipDescription.hasRelationshipProperties() || relationshipDescription.isDynamic() || plainRelationshipRows.isEmpty())) {
                statementHolder = this.neo4jMappingContext.createStatementForImperativeSimpleRelationshipBatch(sourceEntity, relationshipDescription, plainRelationshipRows);
                statementHolder = statementHolder.addProperty("__relationships__", plainRelationshipRows);
                ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bindAll(statementHolder.getProperties())).run();
            } else if (relationshipDescription.hasRelationshipProperties()) {
                if (!relationshipPropertiesRows.isEmpty()) {
                    statementHolder = this.neo4jMappingContext.createStatementForImperativeRelationshipsWithPropertiesBatch(false, sourceEntity, relationshipDescription, updateRelatedValuesToStore, relationshipPropertiesRows);
                    statementHolder = statementHolder.addProperty("__relationships__", relationshipPropertiesRows);
                    ((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bindAll(statementHolder.getProperties())).run();
                } else if (!newRelatedValuesToStore.isEmpty()) {
                    statementHolder = this.neo4jMappingContext.createStatementForImperativeRelationshipsWithPropertiesBatch(true, sourceEntity, relationshipDescription, newRelatedValuesToStore, newRelationshipPropertiesRows);
                    ArrayList all = new ArrayList(((Neo4jClient.RunnableSpec)this.neo4jClient.query(this.renderer.render(statementHolder.getStatement())).bindAll(statementHolder.getProperties())).fetchAs(Long.class).all());
                    for (int i2 = 0; i2 < all.size(); ++i2) {
                        Long aLong = (Long)all.get(i2);
                        this.assignIdToRelationshipProperties(relationshipContext, newRelatedValuesToStore.get(i2), idProperty, aLong);
                    }
                }
            }
            relationshipHandler.applyFinalResultToOwner(propertyAccessor);
        }));
        Object finalSubgraphRoot = propertyAccessor.getBean();
        return (T)finalSubgraphRoot;
    }

    private void assignIdToRelationshipProperties(NestedRelationshipContext relationshipContext, Object relatedValueToStore, Neo4jPersistentProperty idProperty, Long relationshipInternalId) {
        relationshipContext.getRelationshipPropertiesPropertyAccessor(relatedValueToStore).setProperty((PersistentProperty)idProperty, (Object)relationshipInternalId);
    }

    private Entity saveRelatedNode(Object entity, NodeDescription<?> targetNodeDescription, PropertyFilter includeProperty, PropertyFilter.RelaxedPropertyPath currentPropertyPath) {
        Neo4jPersistentEntity targetPersistentEntity = (Neo4jPersistentEntity)targetNodeDescription;
        DynamicLabels dynamicLabels = this.determineDynamicLabels(entity, targetPersistentEntity);
        Class entityType = targetPersistentEntity.getType();
        Function binderFunction = this.neo4jMappingContext.getRequiredBinderFunctionFor(entityType);
        binderFunction = binderFunction.andThen(tree -> {
            boolean assignedId;
            Map properties = (Map)tree.get("__properties__");
            String idPropertyName = ((Neo4jPersistentProperty)targetPersistentEntity.getIdProperty()).getPropertyName();
            IdDescription idDescription = targetPersistentEntity.getIdDescription();
            boolean bl = assignedId = idDescription.isAssignedId() || idDescription.isExternallyGeneratedId();
            if (!includeProperty.isNotFiltering()) {
                properties.entrySet().removeIf(e -> {
                    boolean isIdProperty = ((String)e.getKey()).equals(idPropertyName);
                    return (!assignedId || !isIdProperty) && !includeProperty.contains(currentPropertyPath.append((String)e.getKey()));
                });
            }
            return tree;
        });
        Optional optionalSavedNode = ((Neo4jClient.RunnableSpec)this.neo4jClient.query(() -> this.renderer.render(this.cypherGenerator.prepareSaveOf(targetNodeDescription, dynamicLabels))).bind(entity).with(binderFunction)).fetchAs(Entity.class).one();
        if (targetPersistentEntity.hasVersionProperty() && !optionalSavedNode.isPresent()) {
            throw new OptimisticLockingFailureException(OPTIMISTIC_LOCKING_ERROR_MESSAGE);
        }
        return (Entity)optionalSavedNode.get();
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader == null ? ClassUtils.getDefaultClassLoader() : beanClassLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.eventSupport = EventSupport.discoverCallbacks(this.neo4jMappingContext, beanFactory);
        SpelAwareProxyProjectionFactory spelAwareProxyProjectionFactory = new SpelAwareProxyProjectionFactory();
        spelAwareProxyProjectionFactory.setBeanClassLoader(this.beanClassLoader);
        spelAwareProxyProjectionFactory.setBeanFactory(beanFactory);
        this.projectionFactory = spelAwareProxyProjectionFactory;
        Configuration cypherDslConfiguration = (Configuration)beanFactory.getBeanProvider(Configuration.class).getIfAvailable(Configuration::defaultConfig);
        this.renderer = Renderer.getRenderer((Configuration)cypherDslConfiguration);
    }

    public void setCypherRenderer(Renderer rendererFromCdiConfiguration) {
        this.renderer = rendererFromCdiConfiguration;
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(Class<T> domainType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        return this.createExecutableQuery(domainType, null, queryFragmentsAndParameters);
    }

    private <T> Neo4jOperations.ExecutableQuery<T> createExecutableQuery(Class<T> domainType, @Nullable Class<?> resultType, QueryFragmentsAndParameters queryFragmentsAndParameters) {
        Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction = TemplateSupport.getAndDecorateMappingFunction(this.neo4jMappingContext, domainType, resultType);
        PreparedQuery<T> preparedQuery = PreparedQuery.queryFor(domainType).withQueryFragmentsAndParameters(queryFragmentsAndParameters).usingMappingFunction(mappingFunction).build();
        return this.toExecutableQuery(preparedQuery);
    }

    @Override
    public <T> Neo4jOperations.ExecutableQuery<T> toExecutableQuery(PreparedQuery<T> preparedQuery) {
        return new DefaultExecutableQuery<T>(preparedQuery);
    }

    @Override
    public <T> FluentSaveOperation.ExecutableSave<T> save(Class<T> domainType) {
        return new FluentOperationSupport(this).save(domainType);
    }

    <T, R> List<R> doSave(Iterable<R> instances, Class<T> domainType) {
        if (!instances.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Class<?> resultType = TemplateSupport.findCommonElementType(instances);
        Collection<PropertyFilter.ProjectedPath> pps = PropertyFilterSupport.addPropertiesFrom(domainType, resultType, this.projectionFactory, this.neo4jMappingContext);
        NestedRelationshipProcessingStateMachine stateMachine = new NestedRelationshipProcessingStateMachine(this.neo4jMappingContext);
        ArrayList<Object> results = new ArrayList<Object>();
        EntityFromDtoInstantiatingConverter<T> converter = new EntityFromDtoInstantiatingConverter<T>(domainType, this.neo4jMappingContext);
        for (R instance : instances) {
            T domainObject = converter.convert(instance);
            T savedEntity = this.saveImpl(domainObject, pps, stateMachine);
            Object convertedBack = new DtoInstantiatingConverter(resultType, this.neo4jMappingContext).convertDirectly(savedEntity);
            results.add(convertedBack);
        }
        return results;
    }

    final class DefaultExecutableQuery<T>
    implements Neo4jOperations.ExecutableQuery<T> {
        private final PreparedQuery<T> preparedQuery;

        DefaultExecutableQuery(PreparedQuery<T> preparedQuery) {
            this.preparedQuery = preparedQuery;
        }

        @Override
        public List<T> getResults() {
            Collection all = this.createFetchSpec().map(Neo4jClient.RecordFetchSpec::all).orElse(Collections.emptyList());
            if (this.preparedQuery.resultsHaveBeenAggregated()) {
                return all.stream().flatMap(nested -> ((Collection)nested).stream()).distinct().collect(Collectors.toList());
            }
            return all.stream().collect(Collectors.toList());
        }

        @Override
        public Optional<T> getSingleResult() {
            try {
                Optional<Object> one = this.createFetchSpec().flatMap(Neo4jClient.RecordFetchSpec::one);
                if (this.preparedQuery.resultsHaveBeenAggregated()) {
                    return one.map(aggregatedResults -> ((LinkedHashSet)aggregatedResults).iterator().next());
                }
                return one;
            }
            catch (NoSuchRecordException e) {
                throw new IncorrectResultSizeDataAccessException(e.getMessage(), 1);
            }
        }

        @Override
        public T getRequiredSingleResult() {
            Optional<Object> one = this.createFetchSpec().flatMap(Neo4jClient.RecordFetchSpec::one);
            if (this.preparedQuery.resultsHaveBeenAggregated()) {
                one = one.map(aggregatedResults -> ((LinkedHashSet)aggregatedResults).iterator().next());
            }
            return (T)one.orElseThrow(() -> new NoResultException(1, this.preparedQuery.getQueryFragmentsAndParameters().getCypherQuery()));
        }

        /*
         * Unable to fully structure code
         */
        private Optional<Neo4jClient.RecordFetchSpec<T>> createFetchSpec() {
            queryFragmentsAndParameters = this.preparedQuery.getQueryFragmentsAndParameters();
            cypherQuery = queryFragmentsAndParameters.getCypherQuery();
            finalParameters = queryFragmentsAndParameters.getParameters();
            queryFragments = queryFragmentsAndParameters.getQueryFragments();
            entityMetaData = (Neo4jPersistentEntity)queryFragmentsAndParameters.getNodeDescription();
            if (entityMetaData == null) ** GOTO lbl-1000
            if (entityMetaData.containsPossibleCircles((Predicate<PropertyFilter.RelaxedPropertyPath>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, includeField(org.springframework.data.neo4j.core.mapping.PropertyFilter$RelaxedPropertyPath ), (Lorg/springframework/data/neo4j/core/mapping/PropertyFilter$RelaxedPropertyPath;)Z)((QueryFragments)queryFragments))) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = containsPossibleCircles = false;
            }
            if (cypherQuery == null || containsPossibleCircles) {
                if (containsPossibleCircles && !queryFragments.isScalarValueReturn()) {
                    nodesAndRelationshipsById = this.createNodesAndRelationshipsByIdStatementProvider(entityMetaData, queryFragments, queryFragmentsAndParameters.getParameters());
                    if (nodesAndRelationshipsById.hasRootNodeIds()) {
                        return Optional.empty();
                    }
                    cypherQuery = Neo4jTemplate.access$000(Neo4jTemplate.this).render(nodesAndRelationshipsById.toStatement(entityMetaData));
                    finalParameters = nodesAndRelationshipsById.getParameters();
                } else {
                    statement = queryFragments.toStatement();
                    cypherQuery = Neo4jTemplate.access$000(Neo4jTemplate.this).render(statement);
                    finalParameters = TemplateSupport.mergeParameters(statement, finalParameters);
                }
            }
            newMappingSpec = ((Neo4jClient.RunnableSpec)Neo4jTemplate.access$100(Neo4jTemplate.this).query(cypherQuery).bindAll(finalParameters)).fetchAs(this.preparedQuery.getResultType());
            return Optional.of(this.preparedQuery.getOptionalMappingFunction().map((Function<BiFunction, Neo4jClient.RecordFetchSpec>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, mappedBy(java.util.function.BiFunction<org.neo4j.driver.types.TypeSystem, org.neo4j.driver.Record, T> ), (Ljava/util/function/BiFunction;)Lorg/springframework/data/neo4j/core/Neo4jClient$RecordFetchSpec;)(newMappingSpec)).orElse(newMappingSpec));
        }

        private TemplateSupport.NodesAndRelationshipsByIdStatementProvider createNodesAndRelationshipsByIdStatementProvider(Neo4jPersistentEntity<?> entityMetaData, QueryFragments queryFragments, Map<String, Object> parameters) {
            Statement rootNodesStatement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(entityMetaData, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(new String[]{"__sn__"}).build();
            HashMap<String, Object> usedParameters = new HashMap<String, Object>(parameters);
            usedParameters.putAll(rootNodesStatement.getParameters());
            HashSet<Long> rootNodeIds = new HashSet<Long>(((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(Neo4jTemplate.this.renderer.render(rootNodesStatement)).bindAll(usedParameters)).fetchAs(Value.class).mappedBy((t, r) -> r.get("__sn__")).one().map(value -> value.asList(Value::asLong)).get());
            if (rootNodeIds.isEmpty()) {
                return TemplateSupport.NodesAndRelationshipsByIdStatementProvider.EMPTY;
            }
            HashSet<Long> relationshipIds = new HashSet<Long>();
            HashSet<Long> relatedNodeIds = new HashSet<Long>();
            for (RelationshipDescription relationshipDescription : entityMetaData.getRelationshipsInHierarchy(queryFragments::includeField)) {
                Statement statement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(entityMetaData, relationshipDescription, queryFragments.getMatchOn(), queryFragments.getCondition()).returning(Neo4jTemplate.this.cypherGenerator.createReturnStatementForMatch(entityMetaData)).build();
                usedParameters = new HashMap<String, Object>(parameters);
                usedParameters.putAll(statement.getParameters());
                ((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(Neo4jTemplate.this.renderer.render(statement)).bindAll(usedParameters)).fetch().one().ifPresent(this.iterateAndMapNextLevel(relationshipIds, relatedNodeIds, relationshipDescription, PropertyPathWalkStep.empty()));
            }
            return new TemplateSupport.NodesAndRelationshipsByIdStatementProvider(rootNodeIds, relationshipIds, relatedNodeIds, queryFragments);
        }

        private void iterateNextLevel(Collection<Long> nodeIds, RelationshipDescription sourceRelationshipDescription, Set<Long> relationshipIds, Set<Long> relatedNodeIds, PropertyPathWalkStep currentPathStep) {
            Neo4jPersistentEntity target = (Neo4jPersistentEntity)sourceRelationshipDescription.getTarget();
            String fieldName = ((Neo4jPersistentProperty)((Association)sourceRelationshipDescription).getInverse()).getFieldName();
            PropertyPathWalkStep nextPathStep = currentPathStep.with(sourceRelationshipDescription.hasRelationshipProperties() ? fieldName + "." + ((Neo4jPersistentProperty)((Neo4jPersistentEntity)sourceRelationshipDescription.getRelationshipPropertiesEntity()).getPersistentProperty(TargetNode.class)).getFieldName() : fieldName);
            Collection relationships = target.getRelationshipsInHierarchy(relaxedPropertyPath -> {
                PropertyFilter.RelaxedPropertyPath prepend = relaxedPropertyPath.prepend(nextPathStep.path);
                prepend = PropertyFilter.RelaxedPropertyPath.withRootType(this.preparedQuery.getResultType()).append(prepend.toDotPath());
                return this.preparedQuery.getQueryFragmentsAndParameters().getQueryFragments().includeField(prepend);
            });
            for (RelationshipDescription relationshipDescription : relationships) {
                Node node = Cypher.anyNode((SymbolicName)Constants.NAME_OF_TYPED_ROOT_NODE.apply(target));
                Statement statement = Neo4jTemplate.this.cypherGenerator.prepareMatchOf(target, relationshipDescription, null, Functions.id((Node)node).in((Expression)Cypher.parameter((String)"__ids__"))).returning(Neo4jTemplate.this.cypherGenerator.createGenericReturnStatement()).build();
                ((Neo4jClient.RunnableSpec)Neo4jTemplate.this.neo4jClient.query(Neo4jTemplate.this.renderer.render(statement)).bindAll(Collections.singletonMap("__ids__", nodeIds))).fetch().one().ifPresent(this.iterateAndMapNextLevel(relationshipIds, relatedNodeIds, relationshipDescription, nextPathStep));
            }
        }

        @NonNull
        private Consumer<Map<String, Object>> iterateAndMapNextLevel(Set<Long> relationshipIds, Set<Long> relatedNodeIds, RelationshipDescription relationshipDescription, PropertyPathWalkStep currentPathStep) {
            return record -> {
                List newRelationshipIds = (List)record.get("__sr__");
                relationshipIds.addAll(newRelationshipIds);
                List newRelatedNodeIds = (List)record.get("__srn__");
                HashSet<Long> relatedIds = new HashSet<Long>(newRelatedNodeIds);
                relatedIds.removeAll(relatedNodeIds);
                relatedNodeIds.addAll(relatedIds);
                if (!relatedIds.isEmpty()) {
                    this.iterateNextLevel(relatedIds, relationshipDescription, relationshipIds, relatedNodeIds, currentPathStep);
                }
            };
        }
    }
}

