/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.schema;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyToMapConverter;

final class CompositePropertyConverter<K, P>
implements Neo4jPersistentPropertyConverter<P> {
    private final Neo4jPersistentPropertyToMapConverter<K, P> delegate;
    private final String prefixWithDelimiter;
    private final Neo4jConversionService neo4jConversionService;
    private final Class<?> typeOfKeys;
    private final Function<K, String> keyWriter;
    private final Function<String, K> keyReader;

    CompositePropertyConverter(Neo4jPersistentPropertyToMapConverter<K, P> delegate, String prefixWithDelimiter, Neo4jConversionService neo4jConversionService, Class<?> typeOfKeys, Function<K, String> keyWriter, Function<String, K> keyReader) {
        this.delegate = delegate;
        this.prefixWithDelimiter = prefixWithDelimiter;
        this.neo4jConversionService = neo4jConversionService;
        this.typeOfKeys = typeOfKeys;
        this.keyWriter = keyWriter;
        this.keyReader = keyReader;
    }

    @Override
    public Value write(P property) {
        Map<Object, Value> source = this.delegate.decompose(property, this.neo4jConversionService);
        HashMap temp = new HashMap();
        source.forEach((key, value) -> temp.put(this.prefixWithDelimiter + this.keyWriter.apply(key), value));
        return Values.value(temp);
    }

    @Override
    public P read(Value source) {
        HashMap temp = new HashMap();
        source.keys().forEach(k -> {
            if (k.startsWith(this.prefixWithDelimiter)) {
                K key = this.keyReader.apply(k.substring(this.prefixWithDelimiter.length()));
                temp.put(key, source.get(k));
            }
        });
        return this.delegate.compose(temp, this.neo4jConversionService);
    }

    Class<?> getClassOfDelegate() {
        return this.delegate.getClass();
    }
}

