/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.support;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.R2dbcException;
import java.sql.SQLException;
import java.util.Arrays;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.dao.CannotSerializeTransactionException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DeadlockLoserDataAccessException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.TransientDataAccessResourceException;
import org.springframework.data.r2dbc.BadSqlGrammarException;
import org.springframework.data.r2dbc.InvalidResultAccessException;
import org.springframework.data.r2dbc.support.AbstractFallbackR2dbcExceptionTranslator;
import org.springframework.jdbc.support.SQLErrorCodes;
import org.springframework.jdbc.support.SQLErrorCodesFactory;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.lang.Nullable;

@Deprecated
public class SqlErrorCodeR2dbcExceptionTranslator
extends AbstractFallbackR2dbcExceptionTranslator {
    @Nullable
    private SQLErrorCodes sqlErrorCodes;

    public SqlErrorCodeR2dbcExceptionTranslator() {
    }

    public SqlErrorCodeR2dbcExceptionTranslator(ConnectionFactory connectionFactory) {
        this();
        this.setConnectionFactory(connectionFactory);
    }

    public SqlErrorCodeR2dbcExceptionTranslator(String dbName) {
        this();
        this.setDatabaseProductName(dbName);
    }

    public SqlErrorCodeR2dbcExceptionTranslator(@Nullable SQLErrorCodes sec) {
        this();
        this.sqlErrorCodes = sec;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(connectionFactory.getMetadata().getName());
    }

    public void setDatabaseProductName(String dbName) {
        this.sqlErrorCodes = SQLErrorCodesFactory.getInstance().getErrorCodes(dbName);
    }

    public void setSqlErrorCodes(@Nullable SQLErrorCodes sec) {
        this.sqlErrorCodes = sec;
    }

    @Nullable
    public SQLErrorCodes getSqlErrorCodes() {
        return this.sqlErrorCodes;
    }

    @Override
    @Nullable
    protected DataAccessException doTranslate(String task, @Nullable String sql, R2dbcException ex) {
        DataAccessException customDex;
        SQLExceptionTranslator customTranslator;
        R2dbcException translated = ex;
        DataAccessException dex = this.customTranslate(task, sql, translated);
        if (dex != null) {
            return dex;
        }
        if (this.sqlErrorCodes != null && (customTranslator = this.sqlErrorCodes.getCustomSqlExceptionTranslator()) != null && (customDex = customTranslator.translate(task, sql, new SQLException(ex.getMessage(), ex.getSqlState(), (Throwable)ex))) != null) {
            return customDex;
        }
        if (this.sqlErrorCodes != null) {
            String errorCode;
            if (this.sqlErrorCodes.isUseSqlStateForTranslation()) {
                errorCode = translated.getSqlState();
            } else {
                R2dbcException current = translated;
                while (current.getErrorCode() == 0 && current.getCause() instanceof R2dbcException) {
                    current = (R2dbcException)current.getCause();
                }
                errorCode = Integer.toString(current.getErrorCode());
            }
            if (errorCode != null) {
                if (Arrays.binarySearch(this.sqlErrorCodes.getBadSqlGrammarCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new BadSqlGrammarException(task, sql != null ? sql : "", translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getInvalidResultSetAccessCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new InvalidResultAccessException(task, sql != null ? sql : "", translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDuplicateKeyCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new DuplicateKeyException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDataIntegrityViolationCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new DataIntegrityViolationException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getPermissionDeniedCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new PermissionDeniedDataAccessException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDataAccessResourceFailureCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new DataAccessResourceFailureException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getTransientDataAccessResourceCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new TransientDataAccessResourceException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getCannotAcquireLockCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new CannotAcquireLockException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getDeadlockLoserCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new DeadlockLoserDataAccessException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
                if (Arrays.binarySearch(this.sqlErrorCodes.getCannotSerializeTransactionCodes(), errorCode) >= 0) {
                    this.logTranslation(task, sql, translated);
                    return new CannotSerializeTransactionException(this.buildMessage(task, sql, translated), (Throwable)translated);
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            String codes = this.sqlErrorCodes != null && this.sqlErrorCodes.isUseSqlStateForTranslation() ? "SQL state '" + translated.getSqlState() + "', error code '" + translated.getErrorCode() : "Error code '" + translated.getErrorCode() + "'";
            this.logger.debug((Object)("Unable to translate R2dbcException with " + codes + ", will now try the fallback translator"));
        }
        return null;
    }

    @Nullable
    protected DataAccessException customTranslate(String task, @Nullable String sql, R2dbcException ex) {
        return null;
    }

    private void logTranslation(String task, @Nullable String sql, R2dbcException exception) {
        if (this.logger.isDebugEnabled()) {
            String intro = "Translating";
            this.logger.debug((Object)(intro + " R2dbcException with SQL state '" + exception.getSqlState() + "', error code '" + exception.getErrorCode() + "', message [" + exception.getMessage() + "]" + (sql != null ? "; SQL was [" + sql + "]" : "") + " for task [" + task + "]"));
        }
    }
}

