/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.dao.DataAccessException;
import org.springframework.data.keyvalue.core.AbstractKeyValueAdapter;
import org.springframework.data.keyvalue.core.QueryEngine;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.IndexWriter;
import org.springframework.data.redis.core.PartialUpdate;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisKeyExpiredEvent;
import org.springframework.data.redis.core.RedisKeyspaceEvent;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisQueryEngine;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.CustomConversions;
import org.springframework.data.redis.core.convert.GeoIndexedPropertyValue;
import org.springframework.data.redis.core.convert.MappingRedisConverter;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolverImpl;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.redis.listener.KeyExpirationEventMessageListener;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class RedisKeyValueAdapter
extends AbstractKeyValueAdapter
implements InitializingBean,
ApplicationContextAware,
ApplicationListener<RedisKeyspaceEvent> {
    private RedisOperations<?, ?> redisOps;
    private RedisConverter converter;
    private RedisMessageListenerContainer messageListenerContainer;
    private final AtomicReference<KeyExpirationEventMessageListener> expirationListener = new AtomicReference<Object>(null);
    private ApplicationEventPublisher eventPublisher;
    private EnableKeyspaceEvents enableKeyspaceEvents = EnableKeyspaceEvents.OFF;
    private String keyspaceNotificationsConfigParameter = null;

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps) {
        this(redisOps, new RedisMappingContext());
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisMappingContext mappingContext) {
        this(redisOps, mappingContext, new CustomConversions());
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisMappingContext mappingContext, CustomConversions customConversions) {
        super((QueryEngine)new RedisQueryEngine());
        Assert.notNull(redisOps, (String)"RedisOperations must not be null!");
        Assert.notNull((Object)((Object)mappingContext), (String)"RedisMappingContext must not be null!");
        MappingRedisConverter mappingConverter = new MappingRedisConverter(mappingContext, new PathIndexResolver(mappingContext), new ReferenceResolverImpl(redisOps));
        mappingConverter.setCustomConversions(customConversions == null ? new CustomConversions() : customConversions);
        mappingConverter.afterPropertiesSet();
        this.converter = mappingConverter;
        this.redisOps = redisOps;
        this.initMessageListenerContainer();
    }

    public RedisKeyValueAdapter(RedisOperations<?, ?> redisOps, RedisConverter redisConverter) {
        super((QueryEngine)new RedisQueryEngine());
        Assert.notNull(redisOps, (String)"RedisOperations must not be null!");
        this.converter = redisConverter;
        this.redisOps = redisOps;
        this.initMessageListenerContainer();
    }

    protected RedisKeyValueAdapter() {
    }

    public Object put(Serializable id, Object item, Serializable keyspace) {
        RedisData rdo;
        RedisData redisData = rdo = item instanceof RedisData ? (RedisData)item : new RedisData();
        if (!(item instanceof RedisData)) {
            this.converter.write(item, rdo);
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)EnableKeyspaceEvents.ON_DEMAND), (Object)((Object)this.enableKeyspaceEvents)) && this.expirationListener.get() == null && rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
            this.initKeyExpirationListener();
        }
        if (rdo.getId() == null) {
            rdo.setId((String)this.converter.getConversionService().convert((Object)id, String.class));
            if (!(item instanceof RedisData)) {
                KeyValuePersistentProperty idProperty = (KeyValuePersistentProperty)this.converter.getMappingContext().getPersistentEntity(item.getClass()).getIdProperty();
                this.converter.getMappingContext().getPersistentEntity(item.getClass()).getPropertyAccessor(item).setProperty((PersistentProperty)idProperty, (Object)id);
            }
        }
        this.redisOps.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                byte[] key = RedisKeyValueAdapter.this.toBytes(rdo.getId());
                byte[] objectKey = RedisKeyValueAdapter.this.createKey(rdo.getKeyspace(), rdo.getId());
                boolean isNew = connection.del(new byte[][]{objectKey}) == 0L;
                connection.hMSet(objectKey, rdo.getBucket().rawMap());
                if (rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
                    connection.expire(objectKey, rdo.getTimeToLive());
                    byte[] phantomKey = ByteUtils.concat(objectKey, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                    connection.del(new byte[][]{phantomKey});
                    connection.hMSet(phantomKey, rdo.getBucket().rawMap());
                    connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                }
                connection.sAdd(RedisKeyValueAdapter.this.toBytes(rdo.getKeyspace()), new byte[][]{key});
                IndexWriter indexWriter = new IndexWriter(connection, RedisKeyValueAdapter.this.converter);
                if (isNew) {
                    indexWriter.createIndexes(key, rdo.getIndexedData());
                } else {
                    indexWriter.deleteAndUpdateIndexes(key, rdo.getIndexedData());
                }
                return null;
            }
        });
        return item;
    }

    public boolean contains(final Serializable id, final Serializable keyspace) {
        Boolean exists = this.redisOps.execute(new RedisCallback<Boolean>(){

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sIsMember(RedisKeyValueAdapter.this.toBytes(keyspace), RedisKeyValueAdapter.this.toBytes(id));
            }
        });
        return exists != null ? exists : false;
    }

    public Object get(Serializable id, Serializable keyspace) {
        return this.get(id, keyspace, Object.class);
    }

    public <T> T get(Serializable id, Serializable keyspace, Class<T> type) {
        String stringId = this.asString(id);
        String stringKeyspace = this.asString(keyspace);
        final byte[] binId = this.createKey(stringKeyspace, stringId);
        Map<byte[], byte[]> raw = this.redisOps.execute(new RedisCallback<Map<byte[], byte[]>>(){

            @Override
            public Map<byte[], byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.hGetAll(binId);
            }
        });
        RedisData data = new RedisData(raw);
        data.setId(stringId);
        data.setKeyspace(stringKeyspace);
        return (T)this.readBackTimeToLiveIfSet(binId, this.converter.read(type, data));
    }

    public Object delete(Serializable id, Serializable keyspace) {
        return this.delete(id, keyspace, Object.class);
    }

    public <T> T delete(Serializable id, final Serializable keyspace, Class<T> type) {
        final byte[] binId = this.toBytes(id);
        final byte[] binKeyspace = this.toBytes(keyspace);
        T o = this.get(id, keyspace, type);
        if (o != null) {
            final byte[] keyToDelete = this.createKey(this.asString(keyspace), this.asString(id));
            this.redisOps.execute(new RedisCallback<Void>(){

                @Override
                public Void doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.del(new byte[][]{keyToDelete});
                    connection.sRem(binKeyspace, new byte[][]{binId});
                    new IndexWriter(connection, RedisKeyValueAdapter.this.converter).removeKeyFromIndexes(RedisKeyValueAdapter.this.asString(keyspace), binId);
                    return null;
                }
            });
        }
        return o;
    }

    public List<?> getAllOf(Serializable keyspace) {
        return this.getAllOf(keyspace, -1, -1);
    }

    public List<?> getAllOf(Serializable keyspace, int offset, int rows) {
        final byte[] binKeyspace = this.toBytes(keyspace);
        Set<byte[]> ids = this.redisOps.execute(new RedisCallback<Set<byte[]>>(){

            @Override
            public Set<byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sMembers(binKeyspace);
            }
        });
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> keys = new ArrayList<byte[]>(ids);
        if (keys.isEmpty() || keys.size() < offset) {
            return Collections.emptyList();
        }
        if ((offset = Math.max(0, offset)) >= 0 && rows > 0) {
            keys = keys.subList(offset, Math.min(offset + rows, keys.size()));
        }
        for (byte[] key : keys) {
            result.add(this.get((Serializable)key, keyspace));
        }
        return result;
    }

    public void deleteAllOf(final Serializable keyspace) {
        this.redisOps.execute(new RedisCallback<Void>(){

            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                connection.del(new byte[][]{RedisKeyValueAdapter.this.toBytes(keyspace)});
                new IndexWriter(connection, RedisKeyValueAdapter.this.converter).removeAllIndexes(RedisKeyValueAdapter.this.asString(keyspace));
                return null;
            }
        });
    }

    public CloseableIterator<Map.Entry<Serializable, Object>> entries(Serializable keyspace) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public long count(final Serializable keyspace) {
        Long count = this.redisOps.execute(new RedisCallback<Long>(){

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.sCard(RedisKeyValueAdapter.this.toBytes(keyspace));
            }
        });
        return count != null ? count : 0L;
    }

    public void update(final PartialUpdate<?> update) {
        RedisPersistentEntity<?> entity = this.converter.getMappingContext().getPersistentEntity(update.getTarget());
        final String keyspace = entity.getKeySpace();
        final Object id = update.getId();
        final byte[] redisKey = this.createKey(keyspace, (String)this.converter.getConversionService().convert(id, String.class));
        final RedisData rdo = new RedisData();
        this.converter.write(update, rdo);
        this.redisOps.execute(new RedisCallback<Void>(){

            @Override
            public Void doInRedis(RedisConnection connection) throws DataAccessException {
                RedisUpdateObject redisUpdateObject = new RedisUpdateObject(redisKey, keyspace, id);
                for (PartialUpdate.PropertyUpdate pUpdate : update.getPropertyUpdates()) {
                    String propertyPath = pUpdate.getPropertyPath();
                    if (!PartialUpdate.UpdateCommand.DEL.equals((Object)pUpdate.getCmd()) && !(pUpdate.getValue() instanceof Collection) && !(pUpdate.getValue() instanceof Map) && (pUpdate.getValue() == null || !pUpdate.getValue().getClass().isArray()) && (pUpdate.getValue() == null || RedisKeyValueAdapter.this.converter.getConversionService().canConvert(pUpdate.getValue().getClass(), byte[].class))) continue;
                    redisUpdateObject = RedisKeyValueAdapter.this.fetchDeletePathsFromHashAndUpdateIndex(redisUpdateObject, propertyPath, connection);
                }
                if (!redisUpdateObject.fieldsToRemove.isEmpty()) {
                    connection.hDel(redisKey, (byte[][])redisUpdateObject.fieldsToRemove.toArray((T[])new byte[redisUpdateObject.fieldsToRemove.size()][]));
                }
                for (RedisUpdateObject.Index index : redisUpdateObject.indexesToUpdate) {
                    if (ObjectUtils.nullSafeEquals((Object)((Object)DataType.ZSET), (Object)((Object)index.type))) {
                        connection.zRem(index.key, new byte[][]{RedisKeyValueAdapter.this.toBytes(redisUpdateObject.targetId)});
                        continue;
                    }
                    connection.sRem(index.key, new byte[][]{RedisKeyValueAdapter.this.toBytes(redisUpdateObject.targetId)});
                }
                if (!rdo.getBucket().isEmpty() && (rdo.getBucket().size() > 1 || rdo.getBucket().size() == 1 && !rdo.getBucket().asMap().containsKey("_class"))) {
                    connection.hMSet(redisKey, rdo.getBucket().rawMap());
                }
                if (update.isRefreshTtl()) {
                    if (rdo.getTimeToLive() != null && rdo.getTimeToLive() > 0L) {
                        connection.expire(redisKey, rdo.getTimeToLive());
                        byte[] phantomKey = ByteUtils.concat(redisKey, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX);
                        connection.hMSet(phantomKey, rdo.getBucket().rawMap());
                        connection.expire(phantomKey, rdo.getTimeToLive() + 300L);
                    } else {
                        connection.persist(redisKey);
                        connection.persist(ByteUtils.concat(redisKey, MappingRedisConverter.BinaryKeyspaceIdentifier.PHANTOM_SUFFIX));
                    }
                }
                new IndexWriter(connection, RedisKeyValueAdapter.this.converter).updateIndexes(RedisKeyValueAdapter.this.toBytes(id), rdo.getIndexedData());
                return null;
            }
        });
    }

    private RedisUpdateObject fetchDeletePathsFromHashAndUpdateIndex(RedisUpdateObject redisUpdateObject, String path, RedisConnection connection) {
        redisUpdateObject.addFieldToRemove(this.toBytes(path));
        byte[] value = connection.hGet(redisUpdateObject.targetKey, this.toBytes(path));
        if (value != null && value.length > 0) {
            byte[] existingValueIndexKey;
            byte[] byArray = existingValueIndexKey = value != null ? ByteUtils.concatAll(this.toBytes(redisUpdateObject.keyspace), this.toBytes(":" + path), this.toBytes(":"), value) : null;
            if (connection.exists(existingValueIndexKey).booleanValue()) {
                redisUpdateObject.addIndexToUpdate(new RedisUpdateObject.Index(existingValueIndexKey, DataType.SET));
            }
            return redisUpdateObject;
        }
        Set<byte[]> existingFields = connection.hKeys(redisUpdateObject.targetKey);
        for (byte[] field : existingFields) {
            byte[] existingValueIndexKey;
            if (!this.asString((Serializable)field).startsWith(path + ".")) continue;
            redisUpdateObject.addFieldToRemove(field);
            value = connection.hGet(redisUpdateObject.targetKey, this.toBytes(field));
            if (value == null || !connection.exists(existingValueIndexKey = value != null ? ByteUtils.concatAll(this.toBytes(redisUpdateObject.keyspace), this.toBytes(":"), field, this.toBytes(":"), value) : null).booleanValue()) continue;
            redisUpdateObject.addIndexToUpdate(new RedisUpdateObject.Index(existingValueIndexKey, DataType.SET));
        }
        String pathToUse = GeoIndexedPropertyValue.geoIndexName(path);
        byte[] existingGeoIndexKey = ByteUtils.concatAll(this.toBytes(redisUpdateObject.keyspace), this.toBytes(":"), this.toBytes(pathToUse));
        if (connection.zRank(existingGeoIndexKey, this.toBytes(redisUpdateObject.targetId)) != null) {
            redisUpdateObject.addIndexToUpdate(new RedisUpdateObject.Index(existingGeoIndexKey, DataType.ZSET));
        }
        return redisUpdateObject;
    }

    public <T> T execute(RedisCallback<T> callback) {
        return this.redisOps.execute(callback);
    }

    public RedisConverter getConverter() {
        return this.converter;
    }

    public void clear() {
    }

    private String asString(Serializable value) {
        return value instanceof String ? (String)((Object)value) : (String)this.getConverter().getConversionService().convert((Object)value, String.class);
    }

    public byte[] createKey(String keyspace, String id) {
        return this.toBytes(keyspace + ":" + id);
    }

    public byte[] toBytes(Object source) {
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        return (byte[])this.converter.getConversionService().convert(source, byte[].class);
    }

    private <T> T readBackTimeToLiveIfSet(byte[] key, T target) {
        PersistentProperty<PersistentProperty<?>> ttlProperty;
        TimeToLive ttl;
        Long timeout;
        if (target == null || key == null) {
            return target;
        }
        RedisPersistentEntity<?> entity = this.converter.getMappingContext().getPersistentEntity(target.getClass());
        if (entity.hasExplictTimeToLiveProperty() && ((timeout = this.redisOps.execute(new RedisCallback<Long>(ttl = (TimeToLive)(ttlProperty = entity.getExplicitTimeToLiveProperty()).findAnnotation(TimeToLive.class), key){
            final /* synthetic */ TimeToLive val$ttl;
            final /* synthetic */ byte[] val$key;
            {
                this.val$ttl = timeToLive;
                this.val$key = byArray;
            }

            @Override
            public Long doInRedis(RedisConnection connection) throws DataAccessException {
                if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)this.val$ttl.unit()))) {
                    return connection.ttl(this.val$key);
                }
                return connection.pTtl(this.val$key, this.val$ttl.unit());
            }
        })) != null || !ttlProperty.getType().isPrimitive())) {
            entity.getPropertyAccessor(target).setProperty(ttlProperty, this.converter.getConversionService().convert((Object)timeout, ttlProperty.getType()));
        }
        return target;
    }

    public void setEnableKeyspaceEvents(EnableKeyspaceEvents enableKeyspaceEvents) {
        this.enableKeyspaceEvents = enableKeyspaceEvents;
    }

    public void setKeyspaceNotificationsConfigParameter(String keyspaceNotificationsConfigParameter) {
        this.keyspaceNotificationsConfigParameter = keyspaceNotificationsConfigParameter;
    }

    public void afterPropertiesSet() {
        if (ObjectUtils.nullSafeEquals((Object)((Object)EnableKeyspaceEvents.ON_STARTUP), (Object)((Object)this.enableKeyspaceEvents))) {
            this.initKeyExpirationListener();
        }
    }

    public void destroy() throws Exception {
        if (this.expirationListener.get() != null) {
            this.expirationListener.get().destroy();
        }
        if (this.messageListenerContainer != null) {
            this.messageListenerContainer.destroy();
        }
    }

    public void onApplicationEvent(RedisKeyspaceEvent event) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.eventPublisher = applicationContext;
    }

    private void initMessageListenerContainer() {
        this.messageListenerContainer = new RedisMessageListenerContainer();
        this.messageListenerContainer.setConnectionFactory(((RedisTemplate)this.redisOps).getConnectionFactory());
        this.messageListenerContainer.afterPropertiesSet();
        this.messageListenerContainer.start();
    }

    private void initKeyExpirationListener() {
        if (this.expirationListener.get() == null) {
            MappingExpirationListener listener = new MappingExpirationListener(this.messageListenerContainer, this.redisOps, this.converter);
            listener.setKeyspaceNotificationsConfigParameter(this.keyspaceNotificationsConfigParameter);
            if (this.eventPublisher != null) {
                listener.setApplicationEventPublisher(this.eventPublisher);
            }
            if (this.expirationListener.compareAndSet(null, listener)) {
                listener.init();
            }
        }
    }

    private static class RedisUpdateObject {
        private final String keyspace;
        private final Object targetId;
        private final byte[] targetKey;
        private Set<byte[]> fieldsToRemove = new LinkedHashSet<byte[]>();
        private Set<Index> indexesToUpdate = new LinkedHashSet<Index>();

        RedisUpdateObject(byte[] targetKey, String keyspace, Object targetId) {
            this.targetKey = targetKey;
            this.keyspace = keyspace;
            this.targetId = targetId;
        }

        void addFieldToRemove(byte[] field) {
            this.fieldsToRemove.add(field);
        }

        void addIndexToUpdate(Index index) {
            this.indexesToUpdate.add(index);
        }

        static class Index {
            final DataType type;
            final byte[] key;

            public Index(byte[] key, DataType type) {
                this.key = key;
                this.type = type;
            }
        }
    }

    public static enum EnableKeyspaceEvents {
        ON_STARTUP,
        ON_DEMAND,
        OFF;

    }

    static class MappingExpirationListener
    extends KeyExpirationEventMessageListener {
        private final RedisOperations<?, ?> ops;
        private final RedisConverter converter;

        public MappingExpirationListener(RedisMessageListenerContainer listenerContainer, RedisOperations<?, ?> ops, RedisConverter converter) {
            super(listenerContainer);
            this.ops = ops;
            this.converter = converter;
        }

        @Override
        public void onMessage(Message message, byte[] pattern) {
            if (!this.isKeyExpirationMessage(message)) {
                return;
            }
            byte[] key = message.getBody();
            final byte[] phantomKey = ByteUtils.concat(key, (byte[])this.converter.getConversionService().convert((Object)":phantom", byte[].class));
            Map<byte[], byte[]> hash = this.ops.execute(new RedisCallback<Map<byte[], byte[]>>(){

                @Override
                public Map<byte[], byte[]> doInRedis(RedisConnection connection) throws DataAccessException {
                    Map<byte[], byte[]> hash = connection.hGetAll(phantomKey);
                    if (!CollectionUtils.isEmpty(hash)) {
                        connection.del(new byte[][]{phantomKey});
                    }
                    return hash;
                }
            });
            Object value = this.converter.read(Object.class, new RedisData(hash));
            String channel = !ObjectUtils.isEmpty((Object)message.getChannel()) ? (String)this.converter.getConversionService().convert((Object)message.getChannel(), String.class) : null;
            final RedisKeyExpiredEvent event = new RedisKeyExpiredEvent(channel, key, value);
            this.ops.execute(new RedisCallback<Void>(){

                @Override
                public Void doInRedis(RedisConnection connection) throws DataAccessException {
                    connection.sRem((byte[])MappingExpirationListener.this.converter.getConversionService().convert((Object)event.getKeyspace(), byte[].class), new byte[][]{event.getId()});
                    new IndexWriter(connection, MappingExpirationListener.this.converter).removeKeyFromIndexes(event.getKeyspace(), event.getId());
                    return null;
                }
            });
            this.publishEvent(event);
        }

        private boolean isKeyExpirationMessage(Message message) {
            if (message == null || message.getChannel() == null || message.getBody() == null) {
                return false;
            }
            return MappingRedisConverter.BinaryKeyspaceIdentifier.isValid(message.getBody());
        }
    }
}

