/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisInvalidSubscriptionException;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.util.ByteArrayWrapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class AbstractSubscription
implements Subscription {
    private final Collection<ByteArrayWrapper> channels = new ArrayList<ByteArrayWrapper>(2);
    private final Collection<ByteArrayWrapper> patterns = new ArrayList<ByteArrayWrapper>(2);
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private final MessageListener listener;

    protected AbstractSubscription(MessageListener listener) {
        this(listener, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractSubscription(MessageListener listener, @Nullable byte[][] channels, @Nullable byte[][] patterns) {
        Assert.notNull((Object)listener, (String)"MessageListener must not be null!");
        this.listener = listener;
        Collection<ByteArrayWrapper> collection = this.channels;
        synchronized (collection) {
            AbstractSubscription.add(this.channels, channels);
        }
        collection = this.patterns;
        synchronized (collection) {
            AbstractSubscription.add(this.patterns, patterns);
        }
    }

    protected abstract void doSubscribe(byte[] ... var1);

    protected abstract void doUnsubscribe(boolean var1, byte[] ... var2);

    protected abstract void doPsubscribe(byte[] ... var1);

    protected abstract void doPUnsubscribe(boolean var1, byte[] ... var2);

    @Override
    public void close() {
        this.doClose();
    }

    protected abstract void doClose();

    @Override
    public MessageListener getListener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<byte[]> getChannels() {
        Collection<ByteArrayWrapper> collection = this.channels;
        synchronized (collection) {
            return AbstractSubscription.clone(this.channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<byte[]> getPatterns() {
        Collection<ByteArrayWrapper> collection = this.patterns;
        synchronized (collection) {
            return AbstractSubscription.clone(this.patterns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pSubscribe(byte[] ... patterns) {
        this.checkPulse();
        Assert.notEmpty((Object[])patterns, (String)"at least one pattern required");
        Collection<ByteArrayWrapper> collection = this.patterns;
        synchronized (collection) {
            AbstractSubscription.add(this.patterns, patterns);
        }
        this.doPsubscribe(patterns);
    }

    @Override
    public void pUnsubscribe() {
        this.pUnsubscribe(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void subscribe(byte[] ... channels) {
        this.checkPulse();
        Assert.notEmpty((Object[])channels, (String)"at least one channel required");
        Collection<ByteArrayWrapper> collection = this.channels;
        synchronized (collection) {
            AbstractSubscription.add(this.channels, channels);
        }
        this.doSubscribe(channels);
    }

    @Override
    public void unsubscribe() {
        this.unsubscribe(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pUnsubscribe(byte[] ... patts) {
        if (!this.isAlive()) {
            return;
        }
        if (ObjectUtils.isEmpty((Object[])patts)) {
            if (!this.patterns.isEmpty()) {
                Collection<ByteArrayWrapper> collection = this.patterns;
                synchronized (collection) {
                    patts = (byte[][])this.getPatterns().toArray((T[])new byte[this.patterns.size()][]);
                    this.doPUnsubscribe(true, patts);
                    this.patterns.clear();
                }
            }
            return;
        }
        this.doPUnsubscribe(false, patts);
        Collection<ByteArrayWrapper> collection = this.patterns;
        synchronized (collection) {
            AbstractSubscription.remove(this.patterns, patts);
        }
        this.closeIfUnsubscribed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(byte[] ... chans) {
        if (!this.isAlive()) {
            return;
        }
        if (ObjectUtils.isEmpty((Object[])chans)) {
            if (!this.channels.isEmpty()) {
                Collection<ByteArrayWrapper> collection = this.channels;
                synchronized (collection) {
                    chans = (byte[][])this.getChannels().toArray((T[])new byte[this.channels.size()][]);
                    this.doUnsubscribe(true, chans);
                    this.channels.clear();
                }
            }
            return;
        }
        this.doUnsubscribe(false, chans);
        Collection<ByteArrayWrapper> collection = this.channels;
        synchronized (collection) {
            AbstractSubscription.remove(this.channels, chans);
        }
        this.closeIfUnsubscribed();
    }

    @Override
    public boolean isAlive() {
        return this.alive.get();
    }

    private void checkPulse() {
        if (!this.isAlive()) {
            throw new RedisInvalidSubscriptionException("Subscription has been unsubscribed and cannot be used anymore");
        }
    }

    private void closeIfUnsubscribed() {
        if (this.channels.isEmpty() && this.patterns.isEmpty()) {
            this.alive.set(false);
            this.doClose();
        }
    }

    private static Collection<byte[]> clone(Collection<ByteArrayWrapper> col) {
        ArrayList<byte[]> list = new ArrayList<byte[]>(col.size());
        for (ByteArrayWrapper wrapper : col) {
            list.add((byte[])wrapper.getArray().clone());
        }
        return list;
    }

    private static void add(Collection<ByteArrayWrapper> col, byte[] ... bytes) {
        if (!ObjectUtils.isEmpty((Object[])bytes)) {
            for (byte[] bs : bytes) {
                col.add(new ByteArrayWrapper(bs));
            }
        }
    }

    private static void remove(Collection<ByteArrayWrapper> col, byte[] ... bytes) {
        if (!ObjectUtils.isEmpty((Object[])bytes)) {
            for (byte[] bs : bytes) {
                col.remove(new ByteArrayWrapper(bs));
            }
        }
    }
}

