/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoLocation;

public final class GeoConverters {

    @WritingConverter
    public static enum DistanceToStringConverter implements Converter<Distance, String>
    {
        INSTANCE;


        public String convert(Distance source) {
            if (source == null) {
                return null;
            }
            return String.format(Locale.ENGLISH, "%s", source.getNormalizedValue());
        }
    }

    @ReadingConverter
    public static enum StringToGeoLocationConverter implements Converter<String, GeoLocation>
    {
        INSTANCE;


        public GeoLocation convert(String source) {
            if (source == null) {
                return null;
            }
            String[] coordinates = source.split(",");
            return new GeoLocation(Double.parseDouble(coordinates[0]), Double.parseDouble(coordinates[1]));
        }
    }

    @WritingConverter
    public static enum GeoLocationToStringConverter implements Converter<GeoLocation, String>
    {
        INSTANCE;


        public String convert(GeoLocation source) {
            if (source == null) {
                return null;
            }
            return StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getLatitude()), (String)"0") + "," + StringUtils.stripEnd((String)String.format(Locale.ENGLISH, "%f", source.getLongitude()), (String)"0");
        }
    }
}

