/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.data.solr.core.query.ParameterHolder;
import org.springframework.data.solr.core.query.QueryParameter;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class FieldWithQueryParameters<T extends QueryParameter>
extends SimpleField
implements Iterable<T> {
    private final ParameterHolder<T> parameterHolder = new ParameterHolder();

    public FieldWithQueryParameters(String fieldname) {
        super(fieldname);
        Assert.hasText((String)fieldname);
    }

    public T getQueryParameter(String parameterName) {
        return this.parameterHolder.get(parameterName);
    }

    public void addQueryParameter(T parameter) {
        Assert.notNull(parameter);
        this.parameterHolder.add(parameter);
    }

    public T removeQueryParameter(String parameterName) {
        return this.parameterHolder.remove(parameterName);
    }

    public Collection<T> getQueryParameters() {
        return this.parameterHolder.getParameters();
    }

    public boolean hasQueryParameters() {
        return !this.parameterHolder.isEmpty();
    }

    public <S> S getQueryParameterValue(String parameterName) {
        return this.parameterHolder.getParameterValue(parameterName);
    }

    @Override
    public Iterator<T> iterator() {
        return this.parameterHolder.iterator();
    }
}

