/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.text.MessageFormat;
import java.util.Collection;
import org.apache.solr.client.solrj.SolrRequest;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.data.solr.core.schema.SolrJsonRequest;
import org.springframework.util.CollectionUtils;

public class SolrSchemaRequest
extends SolrJsonRequest {
    private static final long serialVersionUID = 483080361035195746L;

    public SolrSchemaRequest(SolrRequest.METHOD method, String path) {
        super(method, path);
    }

    public static SolrSchemaRequest version() {
        return new SolrSchemaRequestBuilder().forVersion().build();
    }

    public static SolrSchemaRequest schema() {
        return new SolrSchemaRequestBuilder().schema().build();
    }

    public static SolrSchemaRequestBuilder create() {
        return new SolrSchemaRequestBuilder().create();
    }

    public static SolrSchemaRequest name() {
        return new SolrSchemaRequestBuilder().forName().build();
    }

    public static class SolrSchemaRequestBuilder {
        private static final String PATH_PATTERN = "/schema/{0}";
        private String command;
        private SolrRequest.METHOD method;
        private Collection<SchemaDefinition.FieldDefinition> newFields;

        public SolrSchemaRequestBuilder schema() {
            this.method = SolrRequest.METHOD.GET;
            this.command = "";
            return this;
        }

        public SolrSchemaRequestBuilder forName() {
            this.schema();
            this.command = "name";
            return this;
        }

        public SolrSchemaRequestBuilder forVersion() {
            this.method = SolrRequest.METHOD.GET;
            this.command = "version";
            return this;
        }

        public SolrSchemaRequestBuilder create() {
            this.method = SolrRequest.METHOD.POST;
            return this;
        }

        public SolrSchemaRequestBuilder fields(Collection<SchemaDefinition.FieldDefinition> fields) {
            this.command = "fields";
            this.newFields = fields;
            return this;
        }

        public SolrSchemaRequest build() {
            String path = this.buildRequestPath();
            SolrSchemaRequest request = new SolrSchemaRequest(this.method, path);
            if (!CollectionUtils.isEmpty(this.newFields)) {
                request.addContentToStream(this.newFields);
            }
            return request;
        }

        private String buildRequestPath() {
            return MessageFormat.format(PATH_PATTERN, this.command);
        }
    }
}

