/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.impl.LBHttpSolrServer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.server.SolrServerFactory;

abstract class SolrServerFactoryBase
implements SolrServerFactory,
DisposableBean {
    private SolrServer solrServer;

    public SolrServerFactoryBase() {
    }

    SolrServerFactoryBase(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    protected final boolean isHttpSolrServer(SolrServer solrServer) {
        return solrServer instanceof HttpSolrServer;
    }

    @Override
    public SolrServer getSolrServer() {
        return this.solrServer;
    }

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    public void destroy() {
        this.destroy(this.solrServer);
    }

    protected void destroy(SolrServer server) {
        if (this.solrServer instanceof HttpSolrServer) {
            ((HttpSolrServer)this.solrServer).shutdown();
        } else if (this.solrServer instanceof LBHttpSolrServer) {
            ((LBHttpSolrServer)this.solrServer).shutdown();
        } else if (VersionUtil.isSolr4XAvailable() && this.solrServer instanceof CloudSolrServer) {
            ((CloudSolrServer)this.solrServer).shutdown();
        }
    }
}

