/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.solr.core.query.AbstractQuery;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.TermsOptions;
import org.springframework.data.solr.core.query.TermsQuery;
import org.springframework.util.StringUtils;

public class SimpleTermsQuery
extends AbstractQuery
implements TermsQuery {
    public static final String DEFAULT_REQUEST_HANDLER = "/terms";
    private TermsOptions termsOptions = new TermsOptions();
    private List<Field> fields = new ArrayList<Field>(1);

    public void addField(Field field) {
        this.fields.add(field);
    }

    public void addField(String fieldname) {
        this.fields.add(new SimpleField(fieldname));
    }

    public void addFields(String ... fieldnames) {
        for (String fieldname : fieldnames) {
            this.addField(fieldname);
        }
    }

    @Override
    public TermsOptions getTermsOptions() {
        return this.termsOptions;
    }

    @Override
    public List<Field> getTermsFields() {
        return Collections.unmodifiableList(this.fields);
    }

    @Override
    public String getRequestHandler() {
        return StringUtils.hasText((String)super.getRequestHandler()) ? super.getRequestHandler() : DEFAULT_REQUEST_HANDLER;
    }

    public static Builder queryBuilder() {
        return new Builder();
    }

    public static Builder queryBuilder(String ... fieldnames) {
        return new Builder(fieldnames);
    }

    public static class Builder {
        private SimpleTermsQuery query = new SimpleTermsQuery();

        public Builder() {
        }

        public Builder(String ... fieldnames) {
            this.query.addFields(fieldnames);
        }

        public Builder withCriteria(Criteria criteria) {
            this.query.addCriteria(criteria);
            return this;
        }

        public Builder limit(int limit) {
            this.query.termsOptions.setLimit(limit);
            return this;
        }

        public Builder maxCount(int maxCount) {
            this.query.termsOptions.setMaxCount(maxCount);
            return this;
        }

        public Builder minCount(int minCount) {
            this.query.termsOptions.setMinCount(minCount);
            return this;
        }

        public Builder prefix(String prefix) {
            this.query.termsOptions.setPrefix(prefix);
            return this;
        }

        public Builder regex(String regex) {
            this.query.termsOptions.setRegex(regex);
            return this;
        }

        public Builder sort(TermsOptions.Sort sort) {
            this.query.termsOptions.setSort(sort);
            return this;
        }

        public Builder fields(String ... fieldnames) {
            this.query.addFields(fieldnames);
            return this;
        }

        public Builder regexFlag(TermsOptions.RegexFlag flag) {
            this.query.termsOptions.setRegexFlag(flag);
            return this;
        }

        public Builder handledBy(String requestHandler) {
            this.query.setRequestHandler(requestHandler);
            return this;
        }

        public SimpleTermsQuery build() {
            return this.query;
        }
    }
}

