/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.Collection;
import java.util.Map;
import org.apache.solr.client.solrj.request.schema.SchemaRequest;
import org.apache.solr.client.solrj.response.schema.SchemaRepresentation;
import org.apache.solr.client.solrj.response.schema.SchemaResponse;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.data.solr.core.schema.SchemaModificationException;
import org.springframework.data.solr.core.schema.SchemaOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultSchemaOperations
implements SchemaOperations {
    private final SolrTemplate template;
    private final String collection;

    public DefaultSchemaOperations(String collection, SolrTemplate template) {
        Assert.hasText((String)collection, (String)"Collection must not be null or empty!");
        Assert.notNull((Object)template, (String)"Template must not be null.");
        this.template = template;
        this.collection = collection;
    }

    @Override
    public String getSchemaName() {
        return this.template.execute(solrClient -> ((SchemaResponse.SchemaNameResponse)new SchemaRequest.SchemaName().process(solrClient, this.collection)).getSchemaName());
    }

    @Override
    public Double getSchemaVersion() {
        return this.template.execute(solrClient -> new Double(((SchemaResponse.SchemaVersionResponse)new SchemaRequest.SchemaVersion().process(solrClient, this.collection)).getSchemaVersion()));
    }

    @Override
    public SchemaDefinition readSchema() {
        SchemaRepresentation representation = this.template.execute(solrClient -> ((SchemaResponse)new SchemaRequest().process(solrClient, this.collection)).getSchemaRepresentation());
        SchemaDefinition sd = new SchemaDefinition(this.collection);
        for (Map fieldValueMap : representation.getFields()) {
            sd.addFieldDefinition(SchemaDefinition.FieldDefinition.fromMap(fieldValueMap));
        }
        for (Map fieldValueMap : representation.getCopyFields()) {
            SchemaDefinition.CopyFieldDefinition cf = SchemaDefinition.CopyFieldDefinition.fromMap(fieldValueMap);
            sd.addCopyField(cf);
            if (sd.getFieldDefinition(cf.getSource()) == null) continue;
            sd.getFieldDefinition(cf.getSource()).setCopyFields(cf.getDestination());
        }
        return sd;
    }

    @Override
    public void addField(SchemaDefinition.SchemaField field) {
        if (field instanceof SchemaDefinition.FieldDefinition) {
            this.addField((SchemaDefinition.FieldDefinition)field);
        } else if (field instanceof SchemaDefinition.CopyFieldDefinition) {
            this.addCopyField((SchemaDefinition.CopyFieldDefinition)field);
        }
    }

    private void addField(SchemaDefinition.FieldDefinition field) {
        this.template.execute(solrClient -> {
            SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)new SchemaRequest.AddField(field.asMap()).process(solrClient, this.collection);
            if (this.hasErrors(response)) {
                throw new SchemaModificationException(String.format("Adding field %s with args %s to collection %s failed with status %s. Server returned %s.", field.getName(), field.asMap(), this.collection, response.getStatus(), response));
            }
            return response.getStatus();
        });
        if (!CollectionUtils.isEmpty(field.getCopyFields())) {
            SchemaDefinition.CopyFieldDefinition cf = new SchemaDefinition.CopyFieldDefinition();
            cf.setSource(field.getName());
            cf.setDestination(field.getCopyFields());
            this.addCopyField(cf);
        }
    }

    private void addCopyField(SchemaDefinition.CopyFieldDefinition field) {
        this.template.execute(solrClient -> {
            SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)new SchemaRequest.AddCopyField(field.getSource(), field.getDestination()).process(solrClient, this.collection);
            if (this.hasErrors(response)) {
                throw new SchemaModificationException(String.format("Adding copy field %s with destinations %s to collection %s failed with status %s. Server returned %s.", field.getSource(), field.getDestination(), this.collection, response.getStatus(), response));
            }
            return response.getStatus();
        });
    }

    @Override
    public void removeField(String name) {
        this.template.execute(solrClient -> {
            SchemaResponse.UpdateResponse response = (SchemaResponse.UpdateResponse)new SchemaRequest.DeleteField(name).process(solrClient, this.collection);
            if (this.hasErrors(response)) {
                throw new SchemaModificationException(String.format("Removing field with name %s from collection %s failed with status %s. Server returned %s.", name, this.collection, response.getStatus(), response));
            }
            return response.getStatus();
        });
    }

    private boolean hasErrors(SchemaResponse.UpdateResponse response) {
        return response.getStatus() != 0 || response.getResponse() != null && !CollectionUtils.isEmpty((Collection)response.getResponse().getAll("errors"));
    }
}

