/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.net.MalformedURLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.solr.server.support.HttpSolrClientFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class HttpSolrClientFactoryBean
extends HttpSolrClientFactory
implements FactoryBean<SolrClient>,
InitializingBean,
DisposableBean {
    private static final String SERVER_URL_SEPARATOR = ",";
    @Nullable
    private String url;
    @Nullable
    private Integer timeout;
    @Nullable
    private Integer maxConnections;

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.url, (String)"Solr url must not be null nor empty!");
        this.initSolrClient();
    }

    private void initSolrClient() {
        if (this.url.contains(SERVER_URL_SEPARATOR)) {
            this.createLoadBalancedHttpSolrClient();
        } else {
            this.createHttpSolrClient();
        }
    }

    private void createHttpSolrClient() {
        HttpSolrClient httpSolrClient = new HttpSolrClient(this.url);
        if (this.timeout != null) {
            httpSolrClient.setConnectionTimeout(this.timeout.intValue());
        }
        if (this.maxConnections != null) {
            httpSolrClient.setMaxTotalConnections(this.maxConnections.intValue());
        }
        this.setSolrClient((SolrClient)httpSolrClient);
    }

    private void createLoadBalancedHttpSolrClient() {
        try {
            LBHttpSolrClient lbHttpSolrClient = new LBHttpSolrClient(StringUtils.split((String)this.url, (String)SERVER_URL_SEPARATOR));
            if (this.timeout != null) {
                lbHttpSolrClient.setConnectionTimeout(this.timeout.intValue());
            }
            this.setSolrClient((SolrClient)lbHttpSolrClient);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to create Load Balanced Http Solr Server", e);
        }
    }

    public SolrClient getObject() throws Exception {
        return this.getSolrClient();
    }

    public Class<?> getObjectType() {
        if (this.getSolrClient() == null) {
            return HttpSolrClient.class;
        }
        return this.getSolrClient().getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setMaxConnections(Integer maxConnections) {
        this.maxConnections = maxConnections;
    }
}

