/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.data.solr.core.schema.SolrSchemaResolver;
import org.springframework.data.solr.core.schema.SolrSchemaWriter;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public class SolrPersistentEntitySchemaCreator
implements ApplicationListener<MappingContextEvent<?, ?>> {
    private SolrClientFactory factory;
    private SolrSchemaWriter schemaWriter;
    private SolrSchemaResolver schemaResolver;
    private ConcurrentHashMap<Class<?>, Class<?>> processed;
    private Set<Feature> features = new HashSet<Feature>();

    public SolrPersistentEntitySchemaCreator(SolrClientFactory solrClientFactory) {
        this(solrClientFactory, null);
    }

    public SolrPersistentEntitySchemaCreator(SolrClientFactory factory, @Nullable SolrSchemaWriter schemaWriter) {
        this.factory = factory;
        this.schemaWriter = schemaWriter != null ? schemaWriter : new SolrSchemaWriter(this.factory);
        this.schemaResolver = new SolrSchemaResolver();
        this.processed = new ConcurrentHashMap();
    }

    private void process(SolrPersistentEntity<?> entity) {
        SchemaDefinition schema = this.schemaResolver.resolveSchemaForEntity(entity);
        this.beforeSchemaWrite(entity, schema);
        this.schemaWriter.writeSchema(schema);
        this.afterSchemaWrite(entity, schema);
    }

    protected void beforeSchemaWrite(SolrPersistentEntity<?> entity, SchemaDefinition schema) {
    }

    protected void afterSchemaWrite(SolrPersistentEntity<?> entity, SchemaDefinition schema) {
        this.processed.put(entity.getType(), entity.getType());
    }

    public void onApplicationEvent(MappingContextEvent<?, ?> event) {
        SolrPersistentEntity entity;
        if (this.features.contains((Object)Feature.CREATE_MISSING_FIELDS) && event.getPersistentEntity() instanceof SolrPersistentEntity && !this.processed.contains((entity = (SolrPersistentEntity)event.getPersistentEntity()).getType())) {
            this.process(entity);
        }
    }

    public SolrPersistentEntitySchemaCreator enable(@Nullable Feature feature) {
        if (feature != null) {
            this.features.add(feature);
        }
        return this;
    }

    public SolrPersistentEntitySchemaCreator enable(Collection<Feature> features) {
        if (!CollectionUtils.isEmpty(features)) {
            this.features.addAll(features);
        }
        return this;
    }

    public SolrPersistentEntitySchemaCreator disable(Feature feature) {
        this.features.remove((Object)feature);
        return this;
    }

    public static enum Feature {
        CREATE_MISSING_FIELDS;

    }
}

