/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class SchemaDefinition {
    @Nullable
    private String collectionName;
    private List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    private List<CopyFieldDefinition> copyFields = new ArrayList<CopyFieldDefinition>();
    @Nullable
    private String name;
    @Nullable
    private Double version;
    @Nullable
    private String uniqueKey;

    public SchemaDefinition() {
    }

    public SchemaDefinition(String collectionName) {
        this.collectionName = collectionName;
        this.fields = new ArrayList<FieldDefinition>();
    }

    @Nullable
    public String getCollectionName() {
        return this.collectionName;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public void setFields(@Nullable List<FieldDefinition> fields) {
        this.fields = fields != null ? fields : new ArrayList();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Nullable
    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    @Nullable
    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public boolean containsField(String name) {
        return this.getFieldDefinition(name) != null;
    }

    @Nullable
    public FieldDefinition getFieldDefinition(String name) {
        if (CollectionUtils.isEmpty(this.fields)) {
            return null;
        }
        for (FieldDefinition fd : this.fields) {
            if (!ObjectUtils.nullSafeEquals((Object)fd.getName(), (Object)name)) continue;
            return fd;
        }
        return null;
    }

    public void addFieldDefinition(FieldDefinition fieldDef) {
        this.fields.add(fieldDef);
    }

    public void addCopyField(CopyFieldDefinition copyField) {
        this.copyFields.add(copyField);
    }

    public List<CopyFieldDefinition> getCopyFields() {
        return this.copyFields;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public static class FieldDefinitionBuilder {
        private FieldDefinition fieldDef = new FieldDefinition();

        public FieldDefinition idFieldDefinition(String fieldname, String type) {
            this.fieldDef.setName(fieldname);
            this.fieldDef.setType(type);
            this.fieldDef.setIndexed(true);
            this.fieldDef.setStored(true);
            this.fieldDef.setMultiValued(false);
            return this.fieldDef;
        }
    }

    public static class Tokenizer {
        @Nullable
        String clazz;
    }

    public static class Filter {
        @Nullable
        String clazz;
        @Nullable
        String pattern;
        @Nullable
        String replace;
        @Nullable
        String replacement;
    }

    public static class CopyFieldDefinition
    implements SchemaField {
        @Nullable
        String source;
        List<String> destination = Collections.emptyList();

        public static CopyFieldDefinition fromMap(Map<String, Object> fieldValueMap) {
            CopyFieldDefinition cfd = new CopyFieldDefinition();
            cfd.source = (String)fieldValueMap.get("source");
            Object dest = fieldValueMap.get("dest");
            cfd.destination = dest instanceof Collection ? new ArrayList<String>((Collection)dest) : (fieldValueMap.get("dest") instanceof String ? Collections.singletonList(dest.toString()) : Collections.emptyList());
            return cfd;
        }

        public static Builder newCopyFieldDefinition() {
            return new Builder();
        }

        @Nullable
        public String getSource() {
            return this.source;
        }

        public List<String> getDestination() {
            return this.destination;
        }

        public void setSource(@Nullable String source) {
            this.source = source;
        }

        public void setDestination(List<String> destination) {
            this.destination = destination;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CopyFieldDefinition)) {
                return false;
            }
            CopyFieldDefinition other = (CopyFieldDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            List<String> this$destination = this.getDestination();
            List<String> other$destination = other.getDestination();
            return !(this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CopyFieldDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            List<String> $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
            return result;
        }

        public String toString() {
            return "SchemaDefinition.CopyFieldDefinition(source=" + this.getSource() + ", destination=" + this.getDestination() + ")";
        }

        public static class Builder {
            CopyFieldDefinition cf = new CopyFieldDefinition();

            public Builder copyFrom(String source) {
                this.cf.setSource(source);
                return this;
            }

            public Builder to(String ... destinations) {
                if (this.cf.getDestination() == null) {
                    this.cf.setDestination(Arrays.asList(destinations));
                } else {
                    ArrayList<String> values = new ArrayList<String>(this.cf.getDestination());
                    CollectionUtils.mergeArrayIntoCollection((Object)destinations, values);
                    this.cf.setDestination(values);
                }
                return this;
            }

            public CopyFieldDefinition create() {
                return this.cf;
            }
        }
    }

    public static class FieldDefinition
    implements SchemaField {
        @Nullable
        private String name;
        @Nullable
        private String type;
        private boolean stored;
        private boolean indexed;
        @Nullable
        private Object defaultValue;
        private List<String> copyFields = Collections.emptyList();
        private List<Filter> filters = Collections.emptyList();
        private List<Tokenizer> tokenizers = Collections.emptyList();
        private boolean multiValued;
        private boolean required;

        public FieldDefinition(String name) {
            this.name = name;
        }

        public void setCopyFields(Collection<String> copyFields) {
            this.copyFields = new ArrayList<String>(copyFields);
        }

        public Map<String, Object> asMap() {
            LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
            this.addIfNotNull("name", this.name, values);
            this.addIfNotNull("type", this.type, values);
            this.addIfNotNull("indexed", this.indexed, values);
            this.addIfNotNull("stored", this.stored, values);
            this.addIfNotNull("multiValued", this.multiValued, values);
            this.addIfNotNull("default", this.defaultValue, values);
            this.addIfNotNull("required", this.required, values);
            return values;
        }

        private void addIfNotNull(String key, @Nullable Object value, Map<String, Object> dest) {
            if (value != null) {
                dest.put(key, value);
            }
        }

        public static FieldDefinition fromMap(Map<String, Object> source) {
            FieldDefinition fd = new FieldDefinition();
            if (!CollectionUtils.isEmpty(source)) {
                fd.name = FieldDefinition.valueFromMap("name", source, null);
                fd.type = FieldDefinition.valueFromMap("type", source, null);
                fd.indexed = FieldDefinition.valueFromMap("indexed", source, false);
                fd.stored = FieldDefinition.valueFromMap("stored", source, false);
                fd.multiValued = FieldDefinition.valueFromMap("multiValued", source, false);
                fd.required = FieldDefinition.valueFromMap("required", source, false);
                fd.defaultValue = FieldDefinition.valueFromMap("default", source, null);
            }
            return fd;
        }

        private static <T> T valueFromMap(String key, Map<String, Object> source, @Nullable T defaultValue) {
            if (source.containsKey(key)) {
                return (T)source.get(key);
            }
            return defaultValue;
        }

        public static Builder newFieldDefinition() {
            return new Builder();
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        @Nullable
        public String getType() {
            return this.type;
        }

        public boolean isStored() {
            return this.stored;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        @Nullable
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public List<String> getCopyFields() {
            return this.copyFields;
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public List<Tokenizer> getTokenizers() {
            return this.tokenizers;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setName(@Nullable String name) {
            this.name = name;
        }

        public void setType(@Nullable String type) {
            this.type = type;
        }

        public void setStored(boolean stored) {
            this.stored = stored;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public void setDefaultValue(@Nullable Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setFilters(List<Filter> filters) {
            this.filters = filters;
        }

        public void setTokenizers(List<Tokenizer> tokenizers) {
            this.tokenizers = tokenizers;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FieldDefinition)) {
                return false;
            }
            FieldDefinition other = (FieldDefinition)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (this.isStored() != other.isStored()) {
                return false;
            }
            if (this.isIndexed() != other.isIndexed()) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            List<String> this$copyFields = this.getCopyFields();
            List<String> other$copyFields = other.getCopyFields();
            if (this$copyFields == null ? other$copyFields != null : !((Object)this$copyFields).equals(other$copyFields)) {
                return false;
            }
            List<Filter> this$filters = this.getFilters();
            List<Filter> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            List<Tokenizer> this$tokenizers = this.getTokenizers();
            List<Tokenizer> other$tokenizers = other.getTokenizers();
            if (this$tokenizers == null ? other$tokenizers != null : !((Object)this$tokenizers).equals(other$tokenizers)) {
                return false;
            }
            if (this.isMultiValued() != other.isMultiValued()) {
                return false;
            }
            return this.isRequired() == other.isRequired();
        }

        protected boolean canEqual(Object other) {
            return other instanceof FieldDefinition;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + (this.isStored() ? 79 : 97);
            result = result * 59 + (this.isIndexed() ? 79 : 97);
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            List<String> $copyFields = this.getCopyFields();
            result = result * 59 + ($copyFields == null ? 43 : ((Object)$copyFields).hashCode());
            List<Filter> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            List<Tokenizer> $tokenizers = this.getTokenizers();
            result = result * 59 + ($tokenizers == null ? 43 : ((Object)$tokenizers).hashCode());
            result = result * 59 + (this.isMultiValued() ? 79 : 97);
            result = result * 59 + (this.isRequired() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SchemaDefinition.FieldDefinition(name=" + this.getName() + ", type=" + this.getType() + ", stored=" + this.isStored() + ", indexed=" + this.isIndexed() + ", defaultValue=" + this.getDefaultValue() + ", copyFields=" + this.getCopyFields() + ", filters=" + this.getFilters() + ", tokenizers=" + this.getTokenizers() + ", multiValued=" + this.isMultiValued() + ", required=" + this.isRequired() + ")";
        }

        public FieldDefinition() {
        }

        public static class Builder {
            FieldDefinition fd = new FieldDefinition();

            public Builder named(String name) {
                this.fd.setName(name);
                return this;
            }

            public Builder stored() {
                this.fd.setStored(true);
                return this;
            }

            public Builder indexed() {
                this.fd.setIndexed(true);
                return this;
            }

            public Builder muliValued() {
                this.fd.setMultiValued(true);
                return this;
            }

            public Builder copyTo(String ... fields) {
                this.fd.setCopyFields(Arrays.asList(fields));
                return this;
            }

            public Builder required() {
                this.fd.setRequired(true);
                return this;
            }

            public Builder typedAs(String type) {
                this.fd.setType(type);
                return this;
            }

            public Builder defaultedTo(Object value) {
                this.fd.setDefaultValue(value);
                return this;
            }

            public FieldDefinition create() {
                return this.fd;
            }
        }
    }

    public static interface SchemaField {
    }
}

