/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.data.solr.core.SolrTemplate;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.data.solr.core.schema.SchemaOperations;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.util.CollectionUtils;

public class SolrSchemaWriter {
    private final SolrTemplate template;

    public SolrSchemaWriter(SolrClientFactory factory) {
        this.template = new SolrTemplate(factory);
    }

    public void writeSchema(SchemaDefinition schemaDefinition) {
        if (this.isSchemaPresent(schemaDefinition.getCollectionName())) {
            this.updateSchema(schemaDefinition);
            return;
        }
        this.createSchema(schemaDefinition);
    }

    protected void createSchema(SchemaDefinition schemaDefinition) {
        throw new UnsupportedOperationException("The solr rest API does not allow schema creation.");
    }

    protected void updateSchema(SchemaDefinition schemaDefinition) {
        SchemaDefinition existing = this.loadExistingSchema(schemaDefinition.getCollectionName());
        ArrayList<SchemaDefinition.FieldDefinition> fieldsToBeCreated = new ArrayList<SchemaDefinition.FieldDefinition>();
        for (SchemaDefinition.FieldDefinition fieldDefinition : schemaDefinition.getFields()) {
            if (existing.containsField(fieldDefinition.getName())) continue;
            fieldsToBeCreated.add(fieldDefinition);
        }
        this.writeFieldDefinitions(fieldsToBeCreated, schemaDefinition.getCollectionName());
    }

    private void writeFieldDefinitions(Collection<SchemaDefinition.FieldDefinition> definitions, String collectionName) {
        if (!CollectionUtils.isEmpty(definitions)) {
            SchemaOperations schemaOps = this.template.getSchemaOperations(collectionName);
            for (SchemaDefinition.FieldDefinition fd : definitions) {
                schemaOps.addField(fd);
            }
        }
    }

    boolean isSchemaPresent(String collectionName) {
        return !this.retrieveSchemaVersion(collectionName).isNaN();
    }

    SchemaDefinition loadExistingSchema(String collectionName) {
        return this.template.getSchemaOperations(collectionName).readSchema();
    }

    Double retrieveSchemaVersion(String collectionName) {
        return this.template.getSchemaOperations(collectionName).getSchemaVersion();
    }
}

