/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import flex.messaging.endpoints.Endpoint;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.intercept.web.DefaultFilterInvocationDefinitionSource;
import org.springframework.security.intercept.web.RequestKey;
import org.springframework.security.util.UrlMatcher;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointDefinitionSource
extends DefaultFilterInvocationDefinitionSource {
    private Map<String, ConfigAttributeDefinition> endpointMap = new HashMap<String, ConfigAttributeDefinition>();

    public EndpointDefinitionSource(UrlMatcher urlMatcher, LinkedHashMap<RequestKey, ConfigAttributeDefinition> requestMap) {
        super(urlMatcher, requestMap);
    }

    public EndpointDefinitionSource(UrlMatcher urlMatcher, LinkedHashMap<RequestKey, ConfigAttributeDefinition> requestMap, HashMap<String, ConfigAttributeDefinition> endpointMap) {
        super(urlMatcher, requestMap);
        Assert.notNull(endpointMap, (String)"endpointMap cannot be null");
        this.endpointMap = endpointMap;
    }

    public ConfigAttributeDefinition getAttributes(Object object) throws IllegalArgumentException {
        if (object == null || !this.supports(object.getClass())) {
            throw new IllegalArgumentException("Object must be an Endpoint");
        }
        Endpoint endpoint = (Endpoint)object;
        ConfigAttributeDefinition attributes = null;
        attributes = this.endpointMap.containsKey(endpoint.getId()) ? this.endpointMap.get(endpoint.getId()) : this.lookupAttributes(endpoint.getUrlForClient(), null);
        return attributes;
    }

    public Collection getConfigAttributeDefinitions() {
        Collection pathDefinitions = super.getConfigAttributeDefinitions();
        LinkedHashSet<ConfigAttributeDefinition> allDefinitions = new LinkedHashSet<ConfigAttributeDefinition>();
        allDefinitions.addAll(this.endpointMap.values());
        allDefinitions.addAll(pathDefinitions);
        return Collections.unmodifiableCollection(allDefinitions);
    }

    public boolean supports(Class clazz) {
        return Endpoint.class.isAssignableFrom(clazz);
    }
}

