/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.servlet;

import flex.messaging.FlexContext;
import flex.messaging.HttpFlexSession;
import flex.messaging.MessageBroker;
import flex.messaging.MessageException;
import flex.messaging.endpoints.Endpoint;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.context.ServletConfigAware;
import org.springframework.web.servlet.HandlerAdapter;
import org.springframework.web.servlet.ModelAndView;

public class MessageBrokerHandlerAdapter
implements HandlerAdapter,
ServletConfigAware {
    private static final Log logger = LogFactory.getLog(MessageBrokerHandlerAdapter.class);
    private ServletConfig servletConfig;

    public long getLastModified(HttpServletRequest request, Object handler) {
        return -1L;
    }

    public ModelAndView handle(HttpServletRequest req, HttpServletResponse res, Object handler) throws Exception {
        MessageBroker broker = (MessageBroker)handler;
        try {
            broker.initThreadLocals();
            FlexContext.setThreadLocalObjects(null, null, (MessageBroker)broker, (HttpServletRequest)req, (HttpServletResponse)res, (ServletConfig)this.servletConfig);
            HttpFlexSession.getFlexSession((HttpServletRequest)req);
            String contextPath = req.getContextPath();
            String pathInfo = req.getPathInfo();
            String endpointPath = req.getServletPath();
            if (pathInfo != null) {
                endpointPath = String.valueOf(endpointPath) + pathInfo;
            }
            Endpoint endpoint = null;
            try {
                endpoint = broker.getEndpoint(endpointPath, contextPath);
            }
            catch (MessageException messageException) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Received invalid request for endpoint path '" + endpointPath + "'."));
                }
                if (!res.isCommitted()) {
                    res.sendError(404);
                }
                FlexContext.clearThreadLocalObjects();
                return null;
            }
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Channel endpoint " + endpoint.getId() + " received request."));
                }
                endpoint.service(req, res);
            }
            catch (UnsupportedOperationException ue) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Channel endpoint " + endpoint.getId() + " received request for an unsupported operation."), (Throwable)ue);
                }
                if (!res.isCommitted()) {
                    res.sendError(405);
                }
            }
        }
        finally {
            FlexContext.clearThreadLocalObjects();
        }
        return null;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public boolean supports(Object handler) {
        return handler instanceof MessageBroker;
    }
}

