/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.Properties;
import org.apache.geode.security.AuthenticationFailedException;
import org.apache.geode.security.SecurityManager;

public class TestSecurityManager
implements SecurityManager {
    public Object authenticate(Properties credentials) throws AuthenticationFailedException {
        String username = credentials.getProperty("security-username");
        String password = credentials.getProperty("security-password");
        if (!String.valueOf(username).equals(password)) {
            throw new AuthenticationFailedException(String.format("User [%s] could not be authenticated", username));
        }
        return User.create(username);
    }

    public static class User
    implements Comparable<User>,
    Principal,
    Serializable {
        private final String name;

        public static User create(String name) {
            return new User(name);
        }

        public User(String name) {
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("Username is required");
            }
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int compareTo(User user) {
            return this.getName().compareTo(user.getName());
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof User)) {
                return false;
            }
            User that = (User)obj;
            return this.getName().equals(that.getName());
        }

        @Override
        public int hashCode() {
            int hashValue = 17;
            hashValue = 37 * hashValue + this.getName().hashCode();
            return hashValue;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }
}

