/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;

public abstract class AbstractCommonEventProcessingCacheListener<K, V>
extends CacheListenerAdapter<K, V> {
    public void afterCreate(EntryEvent<K, V> event) {
        this.processEntryEvent(event, EntryEventType.CREATE);
    }

    public void afterDestroy(EntryEvent<K, V> event) {
        this.processEntryEvent(event, EntryEventType.DESTROY);
    }

    public void afterInvalidate(EntryEvent<K, V> event) {
        this.processEntryEvent(event, EntryEventType.INVALIDATE);
    }

    public void afterUpdate(EntryEvent<K, V> event) {
        this.processEntryEvent(event, EntryEventType.UPDATE);
    }

    protected void processEntryEvent(EntryEvent<K, V> event, EntryEventType eventType) {
    }

    public void afterRegionClear(RegionEvent<K, V> event) {
        this.processRegionEvent(event, RegionEventType.CLEAR);
    }

    public void afterRegionCreate(RegionEvent<K, V> event) {
        this.processRegionEvent(event, RegionEventType.CREATE);
    }

    public void afterRegionDestroy(RegionEvent<K, V> event) {
        this.processRegionEvent(event, RegionEventType.DESTROY);
    }

    public void afterRegionInvalidate(RegionEvent<K, V> event) {
        this.processRegionEvent(event, RegionEventType.INVALIDATE);
    }

    public void afterRegionLive(RegionEvent<K, V> event) {
        this.processRegionEvent(event, RegionEventType.LIVE);
    }

    protected void processRegionEvent(RegionEvent<K, V> event, RegionEventType eventType) {
    }

    public static enum RegionEventType {
        CLEAR,
        CREATE,
        DESTROY,
        INVALIDATE,
        LIVE;

    }

    public static enum EntryEventType {
        CREATE,
        DESTROY,
        INVALIDATE,
        UPDATE;

    }
}

