/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.pdx;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.geode.internal.Sendable;
import org.apache.geode.pdx.JSONFormatter;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.WritablePdxInstance;
import org.springframework.geode.util.GeodeAssertions;

public class PdxInstanceWrapper
implements PdxInstance,
Sendable {
    public static final String AT_IDENTIFIER_FIELD_NAME = "@identifier";
    public static final String AT_TYPE_FIELD_NAME = "@type";
    public static final String CLASS_NAME_PROPERTY = "className";
    public static final String ID_FIELD_NAME = "id";
    protected static final String NO_FIELD_NAME = "";
    protected static final String ARRAY_BEGIN = "[";
    protected static final String ARRAY_END = "]";
    protected static final String COMMA = ",";
    protected static final String EMPTY_STRING = "";
    protected static final String FIELD_TYPE_VALUE = "\"%1$s\"(%2$s): \"%3$s\"";
    protected static final String INDENT_STRING = "\t";
    protected static final String NEW_LINE = "\n";
    protected static final String COMMA_NEW_LINE = ",\n";
    protected static final String COMMA_SPACE = ", ";
    protected static final String OBJECT_BEGIN = "{";
    protected static final String OBJECT_END = "}";
    private final PdxInstance delegate;

    public static Object from(Object target) {
        return target instanceof PdxInstance ? PdxInstanceWrapper.from((PdxInstance)target) : target;
    }

    public static PdxInstanceWrapper from(PdxInstance pdxInstance) {
        return pdxInstance instanceof PdxInstanceWrapper ? (PdxInstanceWrapper)pdxInstance : new PdxInstanceWrapper(pdxInstance);
    }

    public static PdxInstance unwrap(PdxInstance pdxInstance) {
        return pdxInstance instanceof PdxInstanceWrapper ? ((PdxInstanceWrapper)pdxInstance).getDelegate() : pdxInstance;
    }

    public PdxInstanceWrapper(PdxInstance pdxInstance) {
        GeodeAssertions.assertThat(pdxInstance).isNotNull();
        this.delegate = pdxInstance;
    }

    public PdxInstance getDelegate() {
        return this.delegate;
    }

    protected Optional<ObjectMapper> getObjectMapper() {
        ObjectMapper objectMapper = this.newObjectMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS, true).findAndRegisterModules();
        return Optional.of(objectMapper);
    }

    ObjectMapper newObjectMapper() {
        return new ObjectMapper();
    }

    public String getClassName() {
        return this.getDelegate().getClassName();
    }

    public boolean isDeserializable() {
        return this.getDelegate().isDeserializable();
    }

    public boolean isEnum() {
        return this.getDelegate().isEnum();
    }

    public Object getField(String fieldName) {
        return this.getDelegate().getField(fieldName);
    }

    public List<String> getFieldNames() {
        return this.getDelegate().getFieldNames();
    }

    public Object getIdentifier() {
        Optional<String> identityFieldName = this.nullSafeList(this.getFieldNames()).stream().filter(this::hasText).filter(this::isIdentityField).findFirst();
        return identityFieldName.map(this::getField).orElseGet(this::getId);
    }

    protected Object getId() {
        return this.hasField(ID_FIELD_NAME) ? this.getField(ID_FIELD_NAME) : this.getAtIdentifier();
    }

    protected Object getAtIdentifier() {
        return Optional.of(AT_IDENTIFIER_FIELD_NAME).filter(this::hasField).map(this::getField).map(String::valueOf).filter(this::hasField).map(this::getField).orElseThrow(() -> new IllegalStateException(String.format("PdxInstance for type [%1$s] has no %2$s", this.getClassName(), this.resolveMessageForIdentifierError(this))));
    }

    private String resolveMessageForIdentifierError(PdxInstance pdxInstance) {
        String message = "declared identifier";
        if (pdxInstance.hasField(ID_FIELD_NAME)) {
            message = ID_FIELD_NAME;
        } else if (pdxInstance.hasField(AT_IDENTIFIER_FIELD_NAME)) {
            Object atIdentifierFieldValue = pdxInstance.getField(AT_IDENTIFIER_FIELD_NAME);
            String resolvedIdentifierFieldName = Objects.nonNull(atIdentifierFieldValue) ? atIdentifierFieldValue.toString().trim() : "";
            boolean identifierFieldNameWasDeclaredAndIsValid = pdxInstance.hasField(resolvedIdentifierFieldName);
            Object identifier = identifierFieldNameWasDeclaredAndIsValid ? pdxInstance.getField(resolvedIdentifierFieldName) : null;
            String ifMessage = "value [%s] for field [%s] declared in [%s]";
            String elseMessage = "field [%s] declared in [%s]";
            message = identifierFieldNameWasDeclaredAndIsValid ? String.format(ifMessage, identifier, resolvedIdentifierFieldName, AT_IDENTIFIER_FIELD_NAME) : String.format(elseMessage, resolvedIdentifierFieldName, AT_IDENTIFIER_FIELD_NAME);
        }
        return message;
    }

    public boolean isIdentityField(String fieldName) {
        return this.getDelegate().isIdentityField(fieldName);
    }

    public Object getObject() {
        return this.getObjectMapper().filter(objectMapper -> "__GEMFIRE_JSON".equals(this.getClassName())).filter(objectMapper -> this.hasField(AT_TYPE_FIELD_NAME)).map(objectMapper -> {
            try {
                String typeName = String.valueOf(this.getField(AT_TYPE_FIELD_NAME));
                Class<?> type = Class.forName(typeName);
                String json = this.jsonFormatterToJson(this.getDelegate());
                return objectMapper.readValue(json, type);
            }
            catch (Throwable ignore) {
                return null;
            }
        }).orElseGet(() -> this.getDelegate().getObject());
    }

    String jsonFormatterToJson(PdxInstance pdxInstance) {
        return JSONFormatter.toJSON((PdxInstance)pdxInstance);
    }

    public WritablePdxInstance createWriter() {
        return this.getDelegate().createWriter();
    }

    public boolean hasField(String fieldName) {
        return this.getDelegate().hasField(fieldName);
    }

    public void sendTo(DataOutput out) throws IOException {
        PdxInstance delegate = this.getDelegate();
        if (delegate instanceof Sendable) {
            ((Sendable)delegate).sendTo(out);
        }
    }

    public String toString() {
        return this.toString(this);
    }

    private String toString(PdxInstance pdx) {
        return this.toString(pdx, "");
    }

    private String toString(PdxInstance pdx, String indent) {
        if (Objects.nonNull(pdx)) {
            StringBuilder buffer = new StringBuilder(OBJECT_BEGIN).append(NEW_LINE);
            String fieldIndent = indent + INDENT_STRING;
            buffer.append(fieldIndent).append(this.formatFieldValue(CLASS_NAME_PROPERTY, pdx.getClassName()));
            for (String fieldName : this.nullSafeList(pdx.getFieldNames())) {
                Object fieldValue = pdx.getField(fieldName);
                String valueString = this.toStringObject(fieldValue, fieldIndent);
                buffer.append(COMMA_NEW_LINE);
                buffer.append(fieldIndent).append(this.formatFieldValue(fieldName, valueString));
            }
            buffer.append(NEW_LINE).append(indent).append(OBJECT_END);
            return buffer.toString();
        }
        return null;
    }

    private String toStringArray(Object value, String indent) {
        Object[] array = (Object[])value;
        StringBuilder buffer = new StringBuilder(ARRAY_BEGIN);
        boolean addComma = false;
        for (Object element : array) {
            buffer.append(addComma ? COMMA_SPACE : "");
            buffer.append(this.toStringObject(element, indent));
            addComma = true;
        }
        buffer.append(ARRAY_END);
        return buffer.toString();
    }

    private String toStringObject(Object value, String indent) {
        return this.isPdxInstance(value) ? this.toString((PdxInstance)value, indent) : (this.isArray(value) ? this.toStringArray(value, indent) : String.valueOf(value));
    }

    private String formatFieldValue(String fieldName, Object fieldValue) {
        return String.format(FIELD_TYPE_VALUE, fieldName, this.nullSafeType(fieldValue), fieldValue);
    }

    private boolean hasText(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private boolean isArray(Object value) {
        return Objects.nonNull(value) && value.getClass().isArray();
    }

    private boolean isPdxInstance(Object value) {
        return value instanceof PdxInstance;
    }

    private <T> List<T> nullSafeList(List<T> list) {
        return list != null ? list : Collections.emptyList();
    }

    private Class<?> nullSafeType(Object value) {
        return value != null ? value.getClass() : Object.class;
    }
}

