/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.springframework.geode.util.GeodeAssertions;

public abstract class CacheUtils {
    public static <T> Collection<T> collectValues(Region<?, T> region) {
        GeodeAssertions.assertThat(region).isNotNull();
        return CacheUtils.isClientRegion(region) ? CacheUtils.clientRegionValues(region) : CacheUtils.localRegionValues(region);
    }

    private static <T> Collection<T> clientRegionValues(Region<?, T> region) {
        return CacheUtils.isProxyRegion(region) ? CacheUtils.clientRegionValuesFromServer(region) : CacheUtils.localRegionValues(region);
    }

    private static <T> Collection<T> clientRegionValuesFromServer(Region<?, T> region) {
        Set<T> keys = CacheUtils.nullSafeSet(region.keySetOnServer());
        return !keys.isEmpty() ? CacheUtils.getAll(region, keys) : Collections.emptySet();
    }

    private static <T> Collection<T> getAll(Region<?, T> region, Set<?> keys) {
        return CacheUtils.nullSafeMap(region.getAll(keys)).values();
    }

    private static <T> Collection<T> localRegionValues(Region<?, T> region) {
        return region.values();
    }

    private static boolean hasText(String value) {
        return value != null && !value.trim().isEmpty();
    }

    private static <K, V> Map<K, V> nullSafeMap(Map<K, V> map) {
        return map != null ? map : Collections.emptyMap();
    }

    private static <T> Set<T> nullSafeSet(Set<T> set) {
        return set != null ? set : Collections.emptySet();
    }

    public static boolean isClientCache(RegionService regionService) {
        boolean result = regionService instanceof ClientCache;
        if (regionService instanceof GemFireCacheImpl) {
            result &= ((GemFireCacheImpl)regionService).isClient();
        }
        return result;
    }

    public static boolean isClientRegion(Region<?, ?> region) {
        return region != null && (CacheUtils.isClientCache(region.getRegionService()) || CacheUtils.isRegionWithPool(region));
    }

    public static boolean isPeerCache(RegionService regionService) {
        boolean result = regionService instanceof Cache;
        if (regionService instanceof GemFireCacheImpl) {
            result &= !((GemFireCacheImpl)regionService).isClient();
        }
        return result;
    }

    public static boolean isPeerRegion(Region<?, ?> region) {
        return region != null && !CacheUtils.isClientRegion(region);
    }

    public static boolean isProxyRegion(Region<?, ?> region) {
        return region != null && region.getAttributes() != null && (DataPolicy.EMPTY.equals(region.getAttributes().getDataPolicy()) || CacheUtils.isRegionWithPool(region));
    }

    public static boolean isRegionWithPool(Region<?, ?> region) {
        return Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getPoolName).filter(CacheUtils::hasText).isPresent();
    }
}

