/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.springframework.geode.util.CacheUtils;

public abstract class SimpleCacheResolver {
    private static final AtomicReference<SimpleCacheResolver> instance = new AtomicReference<Object>(null);

    public static SimpleCacheResolver getInstance() {
        return instance.updateAndGet(cacheResolver -> cacheResolver != null ? cacheResolver : SimpleCacheResolver.newSimpleCacheResolver());
    }

    private static SimpleCacheResolver newSimpleCacheResolver() {
        return new SimpleCacheResolver(){};
    }

    private static void testCallResolve() {
        Optional clientCache = SimpleCacheResolver.getInstance().resolve();
    }

    public <T extends GemFireCache> Optional<T> resolve() {
        Optional<ClientCache> clientCache = this.resolveClientCache();
        return clientCache.isPresent() ? clientCache : this.resolvePeerCache();
    }

    public Optional<ClientCache> resolveClientCache() {
        try {
            return Optional.ofNullable(ClientCacheFactory.getAnyInstance()).filter(CacheUtils::isClientCache);
        }
        catch (Throwable ignore) {
            return Optional.empty();
        }
    }

    public Optional<Cache> resolvePeerCache() {
        try {
            return Optional.ofNullable(CacheFactory.getAnyInstance()).filter(CacheUtils::isPeerCache);
        }
        catch (Throwable ignore) {
            return Optional.empty();
        }
    }

    public <T extends GemFireCache> T require() {
        return (T)((GemFireCache)this.resolve().orElseThrow(() -> new IllegalStateException("GemFireCache not found")));
    }
}

