/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.distributed.event;

import java.util.EventObject;
import java.util.Optional;
import org.apache.geode.cache.Cache;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.internal.DistributionManager;

public abstract class MembershipEvent<T extends MembershipEvent<T>>
extends EventObject {
    private DistributedMember distributedMember;

    protected static <T> T assertNotNull(T target, String message, Object ... arguments) {
        if (target == null) {
            throw new IllegalArgumentException(String.format(message, arguments));
        }
        return target;
    }

    public MembershipEvent(DistributionManager distributionManager) {
        super(MembershipEvent.assertNotNull(distributionManager, "DistributionManager must not be null", new Object[0]));
    }

    public Optional<Cache> getCache() {
        return Optional.ofNullable(this.getDistributionManager().getCache());
    }

    public Optional<DistributedMember> getDistributedMember() {
        return Optional.ofNullable(this.distributedMember);
    }

    public Optional<DistributedSystem> getDistributedSystem() {
        return Optional.ofNullable(this.getDistributionManager().getSystem());
    }

    public DistributionManager getDistributionManager() {
        return (DistributionManager)this.getSource();
    }

    public Type getType() {
        return Type.UNQUALIFIED;
    }

    public T withMember(DistributedMember distributedMember) {
        this.distributedMember = distributedMember;
        return (T)this;
    }

    public static enum Type {
        MEMBER_DEPARTED,
        MEMBER_JOINED,
        MEMBER_SUSPECT,
        QUORUM_LOST,
        UNQUALIFIED;

    }
}

