/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.distributed.event.support;

import java.util.Arrays;
import java.util.Collections;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.springframework.geode.distributed.event.MembershipEvent;

public class QuorumLostEvent
extends MembershipEvent<QuorumLostEvent> {
    private Iterable<? extends DistributedMember> remainingMembers = Collections.emptyList();
    private Iterable<? extends DistributedMember> failedMembers = Collections.emptySet();

    public QuorumLostEvent(DistributionManager distributionManager) {
        super(distributionManager);
    }

    public Iterable<? extends DistributedMember> getFailedMembers() {
        return this.failedMembers;
    }

    public Iterable<? extends DistributedMember> getRemainingMembers() {
        return this.remainingMembers;
    }

    public QuorumLostEvent withFailedMembers(DistributedMember ... failedMembers) {
        return this.withFailedMembers(failedMembers != null ? Arrays.asList(failedMembers) : Collections.emptySet());
    }

    public QuorumLostEvent withFailedMembers(Iterable<? extends DistributedMember> failedMembers) {
        this.failedMembers = failedMembers != null ? failedMembers : Collections.emptySet();
        return this;
    }

    public QuorumLostEvent withRemainingMembers(DistributedMember ... remainingMembers) {
        return this.withRemainingMembers(remainingMembers != null ? Arrays.asList(remainingMembers) : Collections.emptyList());
    }

    public QuorumLostEvent withRemainingMembers(Iterable<? extends DistributedMember> remainingMembers) {
        this.remainingMembers = remainingMembers != null ? remainingMembers : Collections.emptyList();
        return this;
    }

    @Override
    public final MembershipEvent.Type getType() {
        return MembershipEvent.Type.QUORUM_LOST;
    }
}

