/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.util;

import java.util.Objects;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.AbstractRegion;
import org.apache.geode.internal.cache.GemFireCacheImpl;

public abstract class GeodeAssertions {
    public static <T> AssertThat<T> assertThat(T obj) {
        return () -> obj;
    }

    private static void assertIsInstanceOf(Object target, Class<?> type) {
        if (!type.isInstance(target)) {
            throw new AssertionError((Object)String.format("[%1$s] is not an instance of [%2$s]", GeodeAssertions.nullSafeTypeName(target), GeodeAssertions.nullSafeTypeName(type)));
        }
    }

    private static void assertIsNotInstanceOf(Object target, Class<?> type) {
        if (type.isInstance(target)) {
            throw new AssertionError((Object)String.format("[%1%s] is an instance of [%2$s]", GeodeAssertions.nullSafeTypeName(target), GeodeAssertions.nullSafeTypeName(type)));
        }
    }

    private static void assertIsNotNull(Object target) {
        if (Objects.isNull(target)) {
            throw new IllegalArgumentException("Argument must not be null");
        }
    }

    private static Class<?> nullSafeType(Object obj) {
        return obj != null ? obj.getClass() : null;
    }

    private static String nullSafeTypeName(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    public static String nullSafeTypeName(Object obj) {
        return GeodeAssertions.nullSafeTypeName(GeodeAssertions.nullSafeType(obj));
    }

    @FunctionalInterface
    public static interface AssertThat<T> {
        public T getSubject();

        default public void isNotNull() {
            GeodeAssertions.assertIsNotNull(this.getSubject());
        }

        default public void isInstanceOfGemFireCacheImpl() {
            GeodeAssertions.assertIsInstanceOf(this.getSubject(), GemFireCacheImpl.class);
        }

        default public void isInstanceOfInternalDistributedSystem() {
            GeodeAssertions.assertIsInstanceOf(this.getSubject(), InternalDistributedSystem.class);
        }

        default public void isNotInstanceOfAbstractRegion() {
            GeodeAssertions.assertIsNotInstanceOf(this.getSubject(), AbstractRegion.class);
        }

        default public void isNotInstanceOfGemFireCacheImpl() {
            GeodeAssertions.assertIsNotInstanceOf(this.getSubject(), GemFireCacheImpl.class);
        }

        default public void isNotInstanceOfInternalDistributedSystem() {
            GeodeAssertions.assertIsNotInstanceOf(this.getSubject(), InternalDistributedSystem.class);
        }
    }
}

