/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.geode.cache.GemFireCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.cache.GemfireCacheManager;
import org.springframework.data.gemfire.cache.config.EnableGemfireCaching;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={ClientCacheAutoConfiguration.class})
@Conditional(value={SpringCacheTypeCondition.class})
@ConditionalOnBean(value={GemFireCache.class})
@ConditionalOnClass(value={GemfireCacheManager.class, GemFireCache.class})
@ConditionalOnMissingBean(value={CacheManager.class})
@EnableGemfireCaching
public class CachingProviderAutoConfiguration {
    protected static final Set<String> SPRING_CACHE_TYPES = CollectionUtils.asSet((Object[])new String[]{"gemfire", "geode"});
    protected static final String SPRING_CACHE_TYPE_PROPERTY = "spring.cache.type";
    private final CacheManagerCustomizers cacheManagerCustomizers;
    private final CacheProperties cacheProperties;
    @Autowired
    private GemfireCacheManager cacheManager;

    CachingProviderAutoConfiguration(@Autowired(required=false) CacheProperties cacheProperties, @Autowired(required=false) CacheManagerCustomizers cacheManagerCustomizers) {
        this.cacheProperties = cacheProperties;
        this.cacheManagerCustomizers = cacheManagerCustomizers;
    }

    GemfireCacheManager getCacheManager() {
        Assert.state((this.cacheManager != null ? 1 : 0) != 0, (String)"GemfireCacheManager was not properly configured");
        return this.cacheManager;
    }

    Optional<CacheManagerCustomizers> getCacheManagerCustomizers() {
        return Optional.ofNullable(this.cacheManagerCustomizers);
    }

    Optional<CacheProperties> getCacheProperties() {
        return Optional.ofNullable(this.cacheProperties);
    }

    @PostConstruct
    public void onGeodeCachingInitialization() {
        this.getCacheManagerCustomizers().ifPresent(cacheManagerCustomizers -> {
            GemfireCacheManager cfr_ignored_0 = (GemfireCacheManager)cacheManagerCustomizers.customize((CacheManager)this.getCacheManager());
        });
    }

    public static class SpringCacheTypeCondition
    implements Condition {
        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String springCacheType = context.getEnvironment().getProperty(CachingProviderAutoConfiguration.SPRING_CACHE_TYPE_PROPERTY);
            return !StringUtils.hasText((String)springCacheType) || SPRING_CACHE_TYPES.contains(springCacheType);
        }
    }
}

