/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Optional;
import java.util.Properties;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnCloudPlatform;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.cloud.CloudPlatform;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableSecurity;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.geode.core.env.VcapPropertySource;
import org.springframework.geode.core.env.support.CloudCacheService;
import org.springframework.geode.core.env.support.Service;
import org.springframework.geode.core.env.support.User;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={ClientCacheAutoConfiguration.class})
@Conditional(value={EnableSecurityCondition.class})
@ConditionalOnClass(value={ClientCacheFactoryBean.class, ClientCache.class})
@ConditionalOnMissingBean(value={GemFireCache.class})
@EnableSecurity
public class ClientSecurityAutoConfiguration {
    public static final String CLOUD_CACHE_SERVICE_INSTANCE_NAME_PROPERTY = "spring.boot.data.gemfire.cloud.cloudfoundry.service.cloudcache.name";
    public static final String CLOUD_SECURITY_ENVIRONMENT_POST_PROCESSOR_ENABLED_PROPERTY = "spring.boot.data.gemfire.security.auth.environment.post-processor.enabled";
    private static final Logger logger = LoggerFactory.getLogger(ClientSecurityAutoConfiguration.class);
    private static final String CLOUD_CACHE_PROPERTY_SOURCE_NAME = "boot.data.gemfire.cloudcache";
    private static final String MANAGEMENT_HTTP_HOST_PROPERTY = "spring.data.gemfire.management.http.host";
    private static final String MANAGEMENT_HTTP_PORT_PROPERTY = "spring.data.gemfire.management.http.port";
    private static final String MANAGEMENT_REQUIRE_HTTPS_PROPERTY = "spring.data.gemfire.management.require-https";
    private static final String MANAGEMENT_USE_HTTP_PROPERTY = "spring.data.gemfire.management.use-http";
    private static final String POOL_LOCATORS_PROPERTY = "spring.data.gemfire.pool.locators";
    private static final String SECURITY_USERNAME_PROPERTY = "spring.data.gemfire.security.username";
    private static final String SECURITY_PASSWORD_PROPERTY = "spring.data.gemfire.security.password";
    private static final String SSL_USE_DEFAULT_CONTEXT_PROPERTY = "spring.data.gemfire.security.ssl.use-default-context";
    private static final String VCAP_PROPERTY_SOURCE_NAME = "vcap";

    static class SpringDataGemFirePropertiesPropertySource
    extends PropertySource<Properties> {
        private static final String SPRING_DATA_GEMFIRE_PROPERTIES_PROPERTY_SOURCE_NAME = "spring.data.gemfire.properties";

        SpringDataGemFirePropertiesPropertySource(Properties springDataGemFireProperties) {
            this(SPRING_DATA_GEMFIRE_PROPERTIES_PROPERTY_SOURCE_NAME, springDataGemFireProperties);
        }

        SpringDataGemFirePropertiesPropertySource(String name, Properties springDataGemFireProperties) {
            super(name, (Object)springDataGemFireProperties);
        }

        @Nullable
        public Object getProperty(String name) {
            return ((Properties)this.getSource()).getProperty(name);
        }

        public boolean containsProperty(String name) {
            return ((Properties)this.getSource()).containsKey(name);
        }
    }

    static class SecurityTriggersCondition
    extends AnyNestedCondition {
        SecurityTriggersCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"gemfire.security-username", "gemfire.security-password"})
        static class UsingApacheGeodeSecurityContextCondition {
            UsingApacheGeodeSecurityContextCondition() {
            }
        }

        @ConditionalOnProperty(value={"spring.data.gemfire.security.username", "spring.data.gemfire.security.password"})
        static class SpringDataGeodeSecurityContextCondition {
            SpringDataGeodeSecurityContextCondition() {
            }
        }

        @ConditionalOnCloudPlatform(value=CloudPlatform.CLOUD_FOUNDRY)
        static class CloudPlatformSecurityContextCondition {
            CloudPlatformSecurityContextCondition() {
            }
        }
    }

    static class EnableSecurityCondition
    extends AllNestedConditions {
        EnableSecurityCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={SecurityTriggersCondition.class})
        static class AnySecurityTriggerCondition {
            AnySecurityTriggerCondition() {
            }
        }

        @ConditionalOnProperty(name={"spring.boot.data.gemfire.security.auth.environment.post-processor.enabled"}, havingValue="true", matchIfMissing=true)
        static class SpringBootDataGemFireSecurityAuthEnvironmentPostProcessorEnabled {
            SpringBootDataGemFireSecurityAuthEnvironmentPostProcessorEnabled() {
            }
        }
    }

    public static class AutoConfiguredCloudSecurityEnvironmentPostProcessor
    implements EnvironmentPostProcessor {
        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            Optional.of(environment).filter(this::isEnabled).filter(this::isCloudFoundryEnvironment).ifPresent(this::configureSecurityContext);
        }

        private boolean isCloudFoundryEnvironment(Environment environment) {
            return CloudPlatform.CLOUD_FOUNDRY.isActive(environment);
        }

        private boolean isEnabled(Environment environment) {
            boolean clientSecurityAutoConfigurationEnabled = (Boolean)environment.getProperty(ClientSecurityAutoConfiguration.CLOUD_SECURITY_ENVIRONMENT_POST_PROCESSOR_ENABLED_PROPERTY, Boolean.class, (Object)true);
            logger.debug("{} enabled? [{}]", (Object)ClientSecurityAutoConfiguration.class.getSimpleName(), (Object)clientSecurityAutoConfigurationEnabled);
            return clientSecurityAutoConfigurationEnabled;
        }

        private boolean isSecurityPropertiesSet(Environment environment) {
            boolean securityPropertiesSet = environment.containsProperty(ClientSecurityAutoConfiguration.SECURITY_USERNAME_PROPERTY) && environment.containsProperty(ClientSecurityAutoConfiguration.SECURITY_PASSWORD_PROPERTY);
            logger.debug("Security Properties set? [{}]", (Object)securityPropertiesSet);
            return securityPropertiesSet;
        }

        private boolean isSecurityPropertiesNotSet(Environment environment) {
            return !this.isSecurityPropertiesSet(environment);
        }

        private void configureAuthentication(Environment environment, VcapPropertySource vcapPropertySource, CloudCacheService cloudCacheService, Properties cloudCacheProperties) {
            if (this.isSecurityPropertiesNotSet(environment)) {
                if (environment.containsProperty(ClientSecurityAutoConfiguration.SECURITY_USERNAME_PROPERTY)) {
                    String targetUsername = environment.getProperty(ClientSecurityAutoConfiguration.SECURITY_USERNAME_PROPERTY);
                    vcapPropertySource.findUserByName((Service)cloudCacheService, targetUsername).flatMap(User::getPassword).map(password -> {
                        cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.SECURITY_USERNAME_PROPERTY, targetUsername);
                        cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.SECURITY_PASSWORD_PROPERTY, (String)password);
                        return password;
                    }).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"No User with name [%s] was configured for Cloud Cache service [%s]", (Object[])new Object[]{targetUsername, cloudCacheService.getName()}));
                } else {
                    vcapPropertySource.findFirstUserByRoleClusterOperator((Service)cloudCacheService).ifPresent(user -> {
                        cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.SECURITY_USERNAME_PROPERTY, user.getName());
                        user.getPassword().ifPresent(password -> cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.SECURITY_PASSWORD_PROPERTY, (String)password));
                    });
                }
            }
        }

        private void configureLocators(Environment environment, VcapPropertySource vcapPropertySource, CloudCacheService cloudCacheService, Properties cloudCacheProperties) {
            cloudCacheService.getLocators().ifPresent(locators -> cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.POOL_LOCATORS_PROPERTY, (String)locators));
        }

        private void configureManagementRestApiAccess(Environment environment, VcapPropertySource vcapPropertySource, CloudCacheService cloudCacheService, Properties cloudCacheProperties) {
            cloudCacheService.getGfshUrl().ifPresent(url -> {
                cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.MANAGEMENT_HTTP_HOST_PROPERTY, url.getHost());
                cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.MANAGEMENT_HTTP_PORT_PROPERTY, String.valueOf(url.getPort()));
                cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.MANAGEMENT_REQUIRE_HTTPS_PROPERTY, Boolean.TRUE.toString());
                cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.MANAGEMENT_USE_HTTP_PROPERTY, Boolean.TRUE.toString());
            });
        }

        private void configureSsl(Environment environment, VcapPropertySource vcapPropertySource, CloudCacheService cloudCacheService, Properties cloudCacheProperties) {
            if (cloudCacheService.isTlsEnabled()) {
                cloudCacheProperties.setProperty(ClientSecurityAutoConfiguration.SSL_USE_DEFAULT_CONTEXT_PROPERTY, Boolean.TRUE.toString());
            }
        }

        public void configureSecurityContext(ConfigurableEnvironment environment) {
            String cloudcacheServiceInstanceName = environment.getProperty(ClientSecurityAutoConfiguration.CLOUD_CACHE_SERVICE_INSTANCE_NAME_PROPERTY);
            VcapPropertySource vcapPropertySource = StringUtils.hasText((String)cloudcacheServiceInstanceName) ? this.toVcapPropertySource((Environment)environment).withVcapServiceName(cloudcacheServiceInstanceName) : this.toVcapPropertySource((Environment)environment);
            vcapPropertySource.findFirstCloudCacheService().map(cloudCacheService -> {
                Properties cloudCacheProperties = new Properties();
                this.configureAuthentication((Environment)environment, vcapPropertySource, (CloudCacheService)cloudCacheService, cloudCacheProperties);
                this.configureLocators((Environment)environment, vcapPropertySource, (CloudCacheService)cloudCacheService, cloudCacheProperties);
                this.configureManagementRestApiAccess((Environment)environment, vcapPropertySource, (CloudCacheService)cloudCacheService, cloudCacheProperties);
                this.configureSsl((Environment)environment, vcapPropertySource, (CloudCacheService)cloudCacheService, cloudCacheProperties);
                environment.getPropertySources().addLast(this.newPropertySource(ClientSecurityAutoConfiguration.CLOUD_CACHE_PROPERTY_SOURCE_NAME, cloudCacheProperties));
                return cloudCacheService;
            }).orElseGet(() -> {
                if (StringUtils.hasText((String)cloudcacheServiceInstanceName)) {
                    throw RuntimeExceptionFactory.newIllegalStateException((String)"No Cloud Cache service instance with name [%s] was found", (Object[])new Object[]{cloudcacheServiceInstanceName});
                }
                logger.warn("No Cloud Cache service instance was found");
                return null;
            });
        }

        private PropertySource<?> newPropertySource(String name, Properties properties) {
            return new SpringDataGemFirePropertiesPropertySource(name, properties);
        }

        private VcapPropertySource toVcapPropertySource(Environment environment) {
            return VcapPropertySource.from((Environment)environment);
        }
    }
}

