/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.geode.cache.GemFireCache;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.geode.boot.autoconfigure.support.PdxInstanceWrapperRegionAspect;
import org.springframework.geode.cache.SimpleCacheResolver;
import org.springframework.geode.data.AbstractCacheDataImporterExporter;
import org.springframework.geode.data.CacheDataImporterExporter;
import org.springframework.geode.data.json.JsonCacheDataImporterExporter;
import org.springframework.geode.data.support.LifecycleAwareCacheDataImporterExporter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@Configuration
@ConditionalOnBean(value={GemFireCache.class})
@ConditionalOnClass(value={CacheFactoryBean.class, GemFireCache.class})
public class DataImportExportAutoConfiguration {
    protected static final String GEMFIRE_DISABLE_SHUTDOWN_HOOK = "gemfire.disableShutdownHook";
    protected static final String PDX_READ_SERIALIZED_PROPERTY = "spring.data.gemfire.pdx.read-serialized";
    protected static final String REGION_ADVICE_ENABLED_PROPERTY = "spring.boot.data.gemfire.cache.region.advice.enabled";
    private static final boolean DEFAULT_EXPORT_ENABLED = false;
    private static final Predicate<Environment> disableGemFireShutdownHookPredicate = environment -> Optional.ofNullable(environment).filter(env -> (Boolean)env.getProperty("spring.boot.data.gemfire.cache.data.export.enabled", Boolean.class, (Object)false)).isPresent();

    @Bean
    CacheDataImporterExporter jsonCacheDataImporterExporter() {
        return new LifecycleAwareCacheDataImporterExporter(this.newCacheDataImporterExporter());
    }

    protected CacheDataImporterExporter newCacheDataImporterExporter() {
        return new JsonCacheDataImporterExporter();
    }

    @Bean
    @Conditional(value={RegionAdviceConditions.class})
    PdxInstanceWrapperRegionAspect pdxInstanceWrapperAspect() {
        return new PdxInstanceWrapperRegionAspect();
    }

    public static class DisableGemFireShutdownHookEnvironmentPostProcessor
    extends AbstractDisableGemFireShutdownHookSupport
    implements EnvironmentPostProcessor {
        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            if (this.shouldDisableGemFireShutdownHook((Environment)environment)) {
                this.disableGemFireShutdownHook((Environment)environment);
            }
        }
    }

    static class DisableGemFireShutdownHookCondition
    extends AbstractDisableGemFireShutdownHookSupport
    implements Condition {
        DisableGemFireShutdownHookCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return this.shouldDisableGemFireShutdownHook(context.getEnvironment());
        }
    }

    static abstract class CacheDataImporterExporterReference
    extends AbstractCacheDataImporterExporter {
        static final String EXPORT_ENABLED_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.export.enabled";

        CacheDataImporterExporterReference() {
        }
    }

    static abstract class AbstractDisableGemFireShutdownHookSupport {
        AbstractDisableGemFireShutdownHookSupport() {
        }

        boolean shouldDisableGemFireShutdownHook(@Nullable Environment environment) {
            return disableGemFireShutdownHookPredicate.test(environment);
        }

        void disableGemFireShutdownHook(@Nullable Environment environment) {
            System.setProperty(DataImportExportAutoConfiguration.GEMFIRE_DISABLE_SHUTDOWN_HOOK, Boolean.TRUE.toString());
        }
    }

    static class PdxReadSerializedCondition
    implements Condition {
        PdxReadSerializedCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return this.isPdxReadSerializedEnabled(context.getEnvironment()) || this.isCachePdxReadSerializedEnabled();
        }

        private boolean isCachePdxReadSerializedEnabled() {
            return SimpleCacheResolver.getInstance().resolve().filter(GemFireCache::getPdxReadSerialized).isPresent();
        }

        private boolean isPdxReadSerializedEnabled(@NonNull Environment environment) {
            return Optional.ofNullable(environment).filter(env -> (Boolean)env.getProperty(DataImportExportAutoConfiguration.PDX_READ_SERIALIZED_PROPERTY, Boolean.class, (Object)false)).isPresent();
        }
    }

    static class RegionAdviceConditions
    extends AnyNestedCondition {
        RegionAdviceConditions() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @Conditional(value={PdxReadSerializedCondition.class})
        static class AdviseRegionOnPdxReadSerializedCondition {
            AdviseRegionOnPdxReadSerializedCondition() {
            }
        }

        @ConditionalOnProperty(name={"spring.boot.data.gemfire.cache.region.advice.enabled"}, havingValue="true")
        static class AdviseRegionOnRegionAdviceEnabledProperty {
            AdviseRegionOnRegionAdviceEnabledProperty() {
            }
        }
    }
}

