/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.geode.cache.GemFireCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemFireProperties;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PeerCacheConfigurer;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={GemFireCache.class, CacheFactoryBean.class})
@AutoConfigureBefore(value={ClientCacheAutoConfiguration.class})
public class EnvironmentSourcedGemFirePropertiesAutoConfiguration {
    private static final String GEMFIRE_PROPERTY_PREFIX = "gemfire.";
    private final Logger logger = LoggerFactory.getLogger(EnvironmentSourcedGemFirePropertiesAutoConfiguration.class);

    @Bean
    @Order(value=0x7FFFFFFF)
    public ClientCacheConfigurer clientCacheGemFirePropertiesConfigurer(ConfigurableEnvironment environment) {
        return (beanName, bean) -> this.configureGemFireProperties(environment, (CacheFactoryBean)bean);
    }

    @Bean
    @Order(value=0x7FFFFFFF)
    public PeerCacheConfigurer peerCacheGemFirePropertiesConfigurer(ConfigurableEnvironment environment) {
        return (beanName, bean) -> this.configureGemFireProperties(environment, (CacheFactoryBean)bean);
    }

    protected void configureGemFireProperties(@NonNull ConfigurableEnvironment environment, @NonNull CacheFactoryBean cache) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)cache, (String)"CacheFactoryBean must not be null");
        MutablePropertySources propertySources = environment.getPropertySources();
        if (propertySources != null) {
            Set gemfirePropertyNames = propertySources.stream().filter(EnumerablePropertySource.class::isInstance).map(EnumerablePropertySource.class::cast).map(EnumerablePropertySource::getPropertyNames).map(propertyNamesArray -> (String[])ArrayUtils.nullSafeArray((Object[])propertyNamesArray, String.class)).flatMap(Arrays::stream).filter(this::isGemFireDotPrefixedProperty).filter(this::isValidGemFireProperty).collect(Collectors.toSet());
            Properties gemfireProperties = cache.getProperties();
            gemfirePropertyNames.stream().filter(gemfirePropertyName -> this.isNotSet(gemfireProperties, (String)gemfirePropertyName)).filter(this::isValidGemFireProperty).forEach(gemfirePropertyName -> {
                String propertyName = this.normalizeGemFirePropertyName((String)gemfirePropertyName);
                String propertyValue = environment.getProperty(gemfirePropertyName);
                if (StringUtils.hasText((String)propertyValue)) {
                    gemfireProperties.setProperty(propertyName, propertyValue);
                } else {
                    this.getLogger().warn("Apache Geode Property [{}] was not set", (Object)propertyName);
                }
            });
            cache.setProperties(gemfireProperties);
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    private boolean isGemFireDotPrefixedProperty(@NonNull String propertyName) {
        return StringUtils.hasText((String)propertyName) && propertyName.startsWith(GEMFIRE_PROPERTY_PREFIX);
    }

    private boolean isNotSet(Properties gemfireProperties, String propertyName) {
        return !gemfireProperties.containsKey(this.normalizeGemFirePropertyName(propertyName));
    }

    private boolean isValidGemFireProperty(String propertyName) {
        try {
            GemFireProperties.from((String)this.normalizeGemFirePropertyName(propertyName));
            return true;
        }
        catch (IllegalArgumentException cause) {
            this.getLogger().warn(String.format("[%s] is not a valid Apache Geode property", propertyName));
            return false;
        }
    }

    private String normalizeGemFirePropertyName(@NonNull String propertyName) {
        int index = propertyName.lastIndexOf(".");
        return index > -1 ? propertyName.substring(index + 1) : propertyName;
    }
}

