/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.type.StandardMethodMetadata;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.data.gemfire.GemfireTemplate;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.ResolvableRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.geode.config.annotation.support.TypelessAnnotationConfigSupport;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureAfter(value={ClientCacheAutoConfiguration.class})
@ConditionalOnBean(value={GemFireCache.class})
@ConditionalOnClass(value={GemfireTemplate.class})
public class RegionTemplateAutoConfiguration
extends TypelessAnnotationConfigSupport {
    private static final Object NON_BEAN = new Object();
    private static final String TEMPLATE = "Template";
    private final Set<String> autoConfiguredRegionTemplateBeanNames = Collections.synchronizedSet(new HashSet());
    private final Set<String> regionNamesWithTemplates = Collections.synchronizedSet(new HashSet());

    @Bean
    BeanFactoryPostProcessor regionTemplateBeanFactoryPostProcessor() {
        return beanFactory -> {
            if (beanFactory instanceof BeanDefinitionRegistry) {
                BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
                List<Object> beanDefinitionNames = Arrays.asList(ArrayUtils.nullSafeArray((Object[])registry.getBeanDefinitionNames(), String.class));
                HashSet<String> userRegionTemplateNames = new HashSet<String>();
                for (String string : beanDefinitionNames) {
                    String regionTemplateBeanName = this.toRegionTemplateBeanName(string);
                    if (beanDefinitionNames.contains(regionTemplateBeanName)) continue;
                    BeanDefinition beanDefinition = registry.getBeanDefinition(string);
                    Class resolvedBeanType = this.resolveBeanClass(beanDefinition, registry).orElse(null);
                    if (this.isRegionBeanDefinition(resolvedBeanType)) {
                        this.register(this.newGemfireTemplateBeanDefinition(string), regionTemplateBeanName, registry);
                        continue;
                    }
                    if (this.isGemfireTemplateBeanDefinition(resolvedBeanType)) {
                        userRegionTemplateNames.add(string);
                        continue;
                    }
                    if (!this.isBeanWithGemfireTemplateDependency((BeanFactory)beanFactory, beanDefinition)) continue;
                    SpringUtils.addDependsOn((BeanDefinition)beanDefinition, (String[])new String[]{"gemfireCache"});
                }
                this.setAutoConfiguredRegionTemplateDependencies(registry, userRegionTemplateNames);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isBeanWithGemfireTemplateDependency(@NonNull BeanFactory beanFactory, @NonNull BeanDefinition beanDefinition) {
        boolean bl;
        boolean match;
        Predicate<Object> isGemfireTemplate = value -> value instanceof RuntimeBeanReference ? beanFactory.isTypeMatch(((RuntimeBeanReference)value).getBeanName(), GemfireOperations.class) : value instanceof GemfireOperations;
        if (!(match |= (match = beanDefinition.getConstructorArgumentValues().getGenericArgumentValues().stream().map(ConstructorArgumentValues.ValueHolder::getValue).anyMatch(isGemfireTemplate)) || beanDefinition.getPropertyValues().getPropertyValueList().stream().map(PropertyValue::getValue).anyMatch(isGemfireTemplate))) {
            if (!Optional.of(beanDefinition).filter(AnnotatedBeanDefinition.class::isInstance).map(AnnotatedBeanDefinition.class::cast).map(AnnotatedBeanDefinition::getFactoryMethodMetadata).filter(StandardMethodMetadata.class::isInstance).map(StandardMethodMetadata.class::cast).map(StandardMethodMetadata::getIntrospectedMethod).map(method -> Arrays.stream(ArrayUtils.nullSafeArray((Object[])method.getParameterTypes(), Class.class)).filter(Objects::nonNull).anyMatch(GemfireOperations.class::isAssignableFrom)).orElse(false).booleanValue()) {
                bl = false;
                return match |= bl;
            }
        }
        bl = true;
        return match |= bl;
    }

    private boolean isGemfireTemplateBeanDefinition(@Nullable Class<?> beanType) {
        return beanType != null && GemfireOperations.class.isAssignableFrom(beanType);
    }

    private boolean isRegionBeanDefinition(@Nullable Class<?> beanType) {
        return beanType != null && ResolvableRegionFactoryBean.class.isAssignableFrom(beanType);
    }

    private BeanDefinition newGemfireTemplateBeanDefinition(String regionBeanName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemfireTemplate.class);
        builder.addConstructorArgReference(regionBeanName);
        return builder.getBeanDefinition();
    }

    private boolean register(BeanDefinition beanDefinition, String beanName, BeanDefinitionRegistry registry) {
        if (this.autoConfiguredRegionTemplateBeanNames.add(beanName)) {
            registry.registerBeanDefinition(beanName, beanDefinition);
            return true;
        }
        return false;
    }

    private void setAutoConfiguredRegionTemplateDependencies(BeanDefinitionRegistry registry, Set<String> dependencyBeanNames) {
        String[] dependencyBeanNamesArray = dependencyBeanNames.toArray(new String[0]);
        this.autoConfiguredRegionTemplateBeanNames.stream().map(arg_0 -> ((BeanDefinitionRegistry)registry).getBeanDefinition(arg_0)).forEach(beanDefinition -> SpringUtils.addDependsOn((BeanDefinition)beanDefinition, (String[])dependencyBeanNamesArray));
    }

    @Bean
    BeanPostProcessor regionTemplateBeanPostProcessor(final ConfigurableApplicationContext applicationContext) {
        this.handlePrematureCacheCreation(applicationContext);
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof GemfireTemplate) {
                    if (RegionTemplateAutoConfiguration.this.autoConfiguredRegionTemplateBeanNames.contains(beanName)) {
                        if (RegionTemplateAutoConfiguration.this.regionNamesWithTemplates.contains(((GemfireTemplate)bean).getRegion().getName())) {
                            bean = NON_BEAN;
                        }
                    } else {
                        RegionTemplateAutoConfiguration.this.regionNamesWithTemplates.add(((GemfireTemplate)bean).getRegion().getName());
                    }
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof GemFireCache) {
                    GemFireCache cache = (GemFireCache)bean;
                    RegionTemplateAutoConfiguration.this.registerRegionTemplatesForCacheRegions(applicationContext, cache);
                }
                return bean;
            }
        };
    }

    private void handlePrematureCacheCreation(ConfigurableApplicationContext applicationContext) {
        Optional.ofNullable(GemfireUtils.resolveGemFireCache()).ifPresent(cache -> this.registerRegionTemplatesForCacheRegions(applicationContext, (GemFireCache)cache));
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void regionTemplateContextRefreshedEventListener(ContextRefreshedEvent event) {
        this.regionNamesWithTemplates.clear();
        ApplicationContext applicationContext = event.getApplicationContext();
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)applicationContext;
            GemFireCache cache = (GemFireCache)configurableApplicationContext.getBean(GemFireCache.class);
            this.registerRegionTemplatesForCacheRegions(configurableApplicationContext, cache);
        }
    }

    private void registerRegionTemplatesForCacheRegions(@NonNull ConfigurableApplicationContext applicationContext, @NonNull GemFireCache cache) {
        for (Region region : CollectionUtils.nullSafeSet((Set)cache.rootRegions())) {
            String regionTemplateBeanName = this.toRegionTemplateBeanName(region.getName());
            this.registerRegionTemplateBean(applicationContext, region, regionTemplateBeanName);
        }
    }

    private void registerRegionTemplateBean(@NonNull ConfigurableApplicationContext applicationContext, @NonNull Region<?, ?> region, String regionTemplateBeanName) {
        Optional.of(applicationContext).filter(it -> this.isNotBean((ApplicationContext)it, regionTemplateBeanName)).map(ConfigurableApplicationContext::getBeanFactory).ifPresent(beanFactory -> this.register(this.newGemfireTemplate(region), regionTemplateBeanName, (ConfigurableBeanFactory)beanFactory));
    }

    private boolean isNotBean(@NonNull ApplicationContext applicationContext, @Nullable String beanName) {
        return !StringUtils.hasText((String)beanName) || !applicationContext.containsBean(beanName);
    }

    private GemfireTemplate newGemfireTemplate(@NonNull Region<?, ?> region) {
        return new GemfireTemplate(region);
    }

    private void register(Object singletonObject, String beanName, ConfigurableBeanFactory beanFactory) {
        if (this.autoConfiguredRegionTemplateBeanNames.add(beanName)) {
            beanFactory.registerSingleton(beanName, singletonObject);
        }
    }

    private String toRegionTemplateBeanName(@NonNull String regionName) {
        return StringUtils.uncapitalize((String)regionName) + TEMPLATE;
    }
}

