/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import java.util.Properties;
import org.apache.geode.cache.GemFireCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.EnableSsl;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.geode.boot.autoconfigure.ClientCacheAutoConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Configuration
@AutoConfigureBefore(value={ClientCacheAutoConfiguration.class})
@Conditional(value={EnableSslCondition.class})
@ConditionalOnClass(value={CacheFactoryBean.class, GemFireCache.class})
@EnableSsl
public class SslAutoConfiguration {
    public static final String SECURITY_SSL_ENVIRONMENT_POST_PROCESSOR_ENABLED_PROPERTY = "spring.boot.data.gemfire.security.ssl.environment.post-processor.enabled";
    private static final String CURRENT_WORKING_DIRECTORY = System.getProperty("user.dir");
    private static final String GEMFIRE_SSL_KEYSTORE_PROPERTY = "gemfire.ssl-keystore";
    private static final String GEMFIRE_SSL_PROPERTY_SOURCE_NAME = "gemfire-ssl";
    private static final String GEMFIRE_SSL_TRUSTSTORE_PROPERTY = "gemfire.ssl-truststore";
    private static final String SECURITY_SSL_PROPERTY_PREFIX = "spring.data.gemfire.security.ssl";
    private static final String SECURITY_SSL_KEYSTORE_PROPERTY = "spring.data.gemfire.security.ssl.keystore";
    private static final String SECURITY_SSL_TRUSTSTORE_PROPERTY = "spring.data.gemfire.security.ssl.truststore";
    private static final String SECURITY_SSL_USE_DEFAULT_CONTEXT = "spring.data.gemfire.security.ssl.use-default-context";
    private static final String TRUSTED_KEYSTORE_FILENAME = "trusted.keystore";
    private static final String TRUSTED_KEYSTORE_FILENAME_PROPERTY = "spring.boot.data.gemfire.security.ssl.keystore.name";
    private static final String USER_HOME_DIRECTORY = System.getProperty("user.home");
    private static final Logger logger = LoggerFactory.getLogger(SslAutoConfiguration.class);

    private static boolean isSslConfigured(Environment environment) {
        return environment.containsProperty(SECURITY_SSL_KEYSTORE_PROPERTY) && environment.containsProperty(SECURITY_SSL_TRUSTSTORE_PROPERTY) || environment.containsProperty(GEMFIRE_SSL_KEYSTORE_PROPERTY) && environment.containsProperty(GEMFIRE_SSL_TRUSTSTORE_PROPERTY);
    }

    private static boolean isSslNotConfigured(Environment environment) {
        return !SslAutoConfiguration.isSslConfigured(environment);
    }

    private static String resolveTrustedKeyStore(Environment environment) {
        return SslAutoConfiguration.locateKeyStoreInFileSystem(environment).map(File::getAbsolutePath).orElseGet(() -> SslAutoConfiguration.locateKeyStoreInUserHome(environment).map(File::getAbsolutePath).orElseGet(() -> SslAutoConfiguration.resolveKeyStoreFromClassPathAsPathname(environment).orElse(null)));
    }

    private static String resolveTrustedKeystoreName(Environment environment) {
        return environment != null && environment.containsProperty(TRUSTED_KEYSTORE_FILENAME_PROPERTY) ? environment.getProperty(TRUSTED_KEYSTORE_FILENAME_PROPERTY) : TRUSTED_KEYSTORE_FILENAME;
    }

    private static Optional<String> resolveKeyStoreFromClassPathAsPathname(Environment environment) {
        return SslAutoConfiguration.resolveKeyStoreFromClassPath(environment).filter(File::isFile).map(File::getAbsolutePath).filter(StringUtils::hasText);
    }

    private static Optional<File> resolveKeyStoreFromClassPath(Environment environment) {
        return SslAutoConfiguration.locateKeyStoreInClassPath(environment).map(resource -> {
            File trustedKeyStore;
            block5: {
                trustedKeyStore = null;
                try {
                    URL url = resource.getURL();
                    if (ResourceUtils.isFileURL((URL)url)) {
                        trustedKeyStore = new File(url.toURI());
                    } else if (ResourceUtils.isJarURL((URL)url)) {
                        trustedKeyStore = new File(CURRENT_WORKING_DIRECTORY, SslAutoConfiguration.resolveTrustedKeystoreName(environment));
                        FileCopyUtils.copy((InputStream)url.openStream(), (OutputStream)new FileOutputStream(trustedKeyStore));
                    }
                }
                catch (IOException | URISyntaxException cause) {
                    if (!logger.isWarnEnabled()) break block5;
                    logger.warn("Trusted KeyStore {} found in Class Path but is not resolvable as a File: {}", resource, (Object)cause.getMessage());
                    if (!logger.isTraceEnabled()) break block5;
                    logger.trace("Caused by:", (Throwable)cause);
                }
            }
            return trustedKeyStore;
        });
    }

    private static Optional<ClassPathResource> locateKeyStoreInClassPath(Environment environment) {
        return SslAutoConfiguration.locateKeyStoreInClassPath(SslAutoConfiguration.resolveTrustedKeystoreName(environment));
    }

    private static Optional<ClassPathResource> locateKeyStoreInClassPath(String keystoreName) {
        return Optional.of(new ClassPathResource(keystoreName)).filter(Resource::exists);
    }

    private static Optional<File> locateKeyStoreInFileSystem(Environment environment) {
        return SslAutoConfiguration.locateKeyStoreInFileSystem(environment, new File(CURRENT_WORKING_DIRECTORY));
    }

    private static Optional<File> locateKeyStoreInFileSystem(Environment environment, File directory) {
        return SslAutoConfiguration.locateKeyStoreInFileSystem(directory, SslAutoConfiguration.resolveTrustedKeystoreName(environment));
    }

    private static Optional<File> locateKeyStoreInFileSystem(String keystoreName) {
        return SslAutoConfiguration.locateKeyStoreInFileSystem(new File(CURRENT_WORKING_DIRECTORY), keystoreName);
    }

    private static Optional<File> locateKeyStoreInFileSystem(File directory, String keystoreFilename) {
        SslAutoConfiguration.assertDirectory(directory);
        for (File file : SslAutoConfiguration.nullSafeListFiles(directory)) {
            if (SslAutoConfiguration.isDirectory(file)) {
                Optional<File> theFile = SslAutoConfiguration.locateKeyStoreInFileSystem(file, keystoreFilename);
                if (!theFile.isPresent()) continue;
                return theFile;
            }
            if (!file.getName().equals(keystoreFilename)) continue;
            return Optional.of(file);
        }
        return Optional.empty();
    }

    private static Optional<File> locateKeyStoreInUserHome(Environment environment) {
        return SslAutoConfiguration.locateKeyStoreInUserHome(SslAutoConfiguration.resolveTrustedKeystoreName(environment));
    }

    private static Optional<File> locateKeyStoreInUserHome(String keystoreFilename) {
        return Optional.of(new File(USER_HOME_DIRECTORY, keystoreFilename)).filter(File::isFile);
    }

    private static void assertDirectory(File path) {
        Assert.isTrue((boolean)SslAutoConfiguration.isDirectory(path), (String)String.format("[%s] is not a valid directory", path));
    }

    private static boolean isDirectory(File path) {
        return path != null && path.isDirectory();
    }

    private static File[] nullSafeListFiles(File directory) {
        return (File[])ArrayUtils.nullSafeArray((Object[])directory.listFiles(), File.class);
    }

    static class TrustedKeyStoreIsPresentCondition
    implements Condition {
        TrustedKeyStoreIsPresentCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Environment environment = context.getEnvironment();
            return SslAutoConfiguration.locateKeyStoreInClassPath(environment).isPresent() || SslAutoConfiguration.locateKeyStoreInFileSystem(environment).isPresent() || SslAutoConfiguration.locateKeyStoreInUserHome(environment).isPresent();
        }
    }

    static class SslTriggersCondition
    extends AnyNestedCondition {
        public SslTriggersCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(value={"gemfire.ssl-keystore", "gemfire.ssl-truststore"})
        static class ApacheGeodeSslKeyStoreAndTruststorePropertiesSet {
            ApacheGeodeSslKeyStoreAndTruststorePropertiesSet() {
            }
        }

        @ConditionalOnProperty(value={"spring.data.gemfire.security.ssl.use-default-context"})
        static class SpringDataGeodeSslUseDefaultContextPropertySet {
            SpringDataGeodeSslUseDefaultContextPropertySet() {
            }
        }

        @ConditionalOnProperty(prefix="spring.data.gemfire.security.ssl", name={"keystore", "truststore"})
        static class SpringDataGemFireSecuritySslKeyStoreAndTruststorePropertiesSet {
            SpringDataGemFireSecuritySslKeyStoreAndTruststorePropertiesSet() {
            }
        }

        @Conditional(value={TrustedKeyStoreIsPresentCondition.class})
        static class TrustedKeyStoreCondition {
            TrustedKeyStoreCondition() {
            }
        }
    }

    static class EnableSslCondition
    extends AllNestedConditions {
        public EnableSslCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @Conditional(value={SslTriggersCondition.class})
        static class AnySslTriggerCondition {
            AnySslTriggerCondition() {
            }
        }

        @ConditionalOnProperty(name={"spring.boot.data.gemfire.security.ssl.environment.post-processor.enabled"}, havingValue="true", matchIfMissing=true)
        static class SpringBootDataGemFireSecuritySslEnvironmentPostProcessorEnabled {
            SpringBootDataGemFireSecuritySslEnvironmentPostProcessorEnabled() {
            }
        }
    }

    public static class SslEnvironmentPostProcessor
    implements EnvironmentPostProcessor {
        public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
            Optional.of(environment).filter(this::isEnabled).filter(x$0 -> SslAutoConfiguration.isSslNotConfigured(x$0)).map(x$0 -> SslAutoConfiguration.resolveTrustedKeyStore(x$0)).filter(StringUtils::hasText).ifPresent(trustedKeyStore -> this.configureSsl(environment, (String)trustedKeyStore));
        }

        private PropertySource<?> newPropertySource(String name, Properties properties) {
            return new PropertiesPropertySource(name, properties);
        }

        private boolean isEnabled(Environment environment) {
            return (Boolean)environment.getProperty(SslAutoConfiguration.SECURITY_SSL_ENVIRONMENT_POST_PROCESSOR_ENABLED_PROPERTY, Boolean.class, (Object)true);
        }

        private void configureSsl(ConfigurableEnvironment environment, String trustedKeyStore) {
            Properties gemfireSslProperties = new Properties();
            gemfireSslProperties.setProperty(SslAutoConfiguration.SECURITY_SSL_KEYSTORE_PROPERTY, trustedKeyStore);
            gemfireSslProperties.setProperty(SslAutoConfiguration.SECURITY_SSL_TRUSTSTORE_PROPERTY, trustedKeyStore);
            environment.getPropertySources().addFirst(this.newPropertySource(SslAutoConfiguration.GEMFIRE_SSL_PROPERTY_SOURCE_NAME, gemfireSslProperties));
        }
    }
}

