/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure.support;

import java.util.Optional;
import java.util.Set;
import org.apache.shiro.util.CollectionUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.gemfire.config.annotation.ClientCacheConfigurer;
import org.springframework.data.gemfire.config.annotation.PoolConfigurer;

@Configuration
public class EnableSubscriptionConfiguration {
    private static final String DEFAULT_POOL_NAME = "DEFAULT";
    private static final String GEMFIRE_POOL_NAME = "gemfirePool";
    private static final Set<String> POOL_NAMES = CollectionUtils.asSet((Object[])new String[]{"DEFAULT", "gemfirePool"});

    @Bean
    public ClientCacheConfigurer enableSubscriptionClientCacheConfigurer() {
        return (beanName, clientCacheFactoryBean) -> clientCacheFactoryBean.setSubscriptionEnabled(Boolean.valueOf(true));
    }

    @Bean
    public PoolConfigurer enableSubscriptionPoolConfigurer() {
        return (beanName, poolFactoryBean) -> Optional.ofNullable(beanName).filter(POOL_NAMES::contains).ifPresent(poolName -> poolFactoryBean.setSubscriptionEnabled(true));
    }
}

