/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure.support;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.gemfire.config.admin.remote.RestHttpGemfireAdminTemplate;
import org.springframework.data.gemfire.config.annotation.ClusterConfigurationConfiguration;
import org.springframework.geode.core.util.ObjectUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Deprecated
@Configuration
public class HttpBasicAuthenticationSecurityConfiguration {
    private static final String DEFAULT_USERNAME = "test";
    private static final String DEFAULT_PASSWORD = "test";
    private static final String SPRING_DATA_GEMFIRE_SECURITY_USERNAME_PROPERTY = "spring.data.gemfire.security.username";
    private static final String SPRING_DATA_GEMFIRE_SECURITY_PASSWORD_PROPERTY = "spring.data.gemfire.security.password";

    @Bean
    public Authenticator authenticator(final Environment environment) {
        Authenticator authenticator = new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                String username = environment.getProperty(HttpBasicAuthenticationSecurityConfiguration.SPRING_DATA_GEMFIRE_SECURITY_USERNAME_PROPERTY, "test");
                String password = environment.getProperty(HttpBasicAuthenticationSecurityConfiguration.SPRING_DATA_GEMFIRE_SECURITY_PASSWORD_PROPERTY, "test");
                return new PasswordAuthentication(username, password.toCharArray());
            }
        };
        Authenticator.setDefault(authenticator);
        return authenticator;
    }

    @Bean
    public BeanPostProcessor schemaObjectInitializerPostProcessor(final Environment environment) {
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof ClusterConfigurationConfiguration.ClusterSchemaObjectInitializer) {
                    Optional.of(bean).map(schemaObjectInitializer -> HttpBasicAuthenticationSecurityConfiguration.this.invokeMethod(schemaObjectInitializer, "getSchemaObjectContext", new Object[0])).filter(ClusterConfigurationConfiguration.SchemaObjectContext.class::isInstance).map(schemaObjectContext -> HttpBasicAuthenticationSecurityConfiguration.this.invokeMethod(schemaObjectContext, "getGemfireAdminOperations", new Object[0])).filter(RestHttpGemfireAdminTemplate.class::isInstance).map(gemfireAdminTemplate -> HttpBasicAuthenticationSecurityConfiguration.this.invokeMethod(gemfireAdminTemplate, "getRestOperations", new Object[0])).filter(RestTemplate.class::isInstance).map(RestTemplate.class::cast).ifPresent(restTemplate -> HttpBasicAuthenticationSecurityConfiguration.this.registerInterceptor((RestTemplate)restTemplate, new SecurityAwareClientHttpRequestInterceptor(environment)));
                }
                return bean;
            }
        };
    }

    @Nullable
    protected <T> T invokeMethod(@NonNull Object target, @NonNull String methodName, Object ... args) {
        ObjectUtils.ExceptionThrowingOperation operation = () -> ObjectUtils.findMethod(target.getClass(), (String)methodName, (Object[])args).map(ObjectUtils::makeAccessible).map(method -> ReflectionUtils.invokeMethod((Method)method, (Object)ObjectUtils.resolveInvocationTarget((Object)target, (Method)method), (Object[])args)).orElse(null);
        Function<Throwable, Object> exceptionHandlingFunction = cause -> null;
        return (T)ObjectUtils.doOperationSafely((ObjectUtils.ExceptionThrowingOperation)operation, exceptionHandlingFunction);
    }

    protected RestTemplate registerInterceptor(RestTemplate restTemplate, ClientHttpRequestInterceptor clientHttpRequestInterceptor) {
        restTemplate.getInterceptors().add(clientHttpRequestInterceptor);
        return restTemplate;
    }

    public static class SecurityAwareClientHttpRequestInterceptor
    implements ClientHttpRequestInterceptor {
        private final Environment environment;

        public SecurityAwareClientHttpRequestInterceptor(Environment environment) {
            Assert.notNull((Object)environment, (String)"Environment is required");
            this.environment = environment;
        }

        protected boolean isAuthenticationEnabled() {
            return StringUtils.hasText((String)this.getUsername()) && StringUtils.hasText((String)this.getPassword());
        }

        protected String getUsername() {
            return this.environment.getProperty(HttpBasicAuthenticationSecurityConfiguration.SPRING_DATA_GEMFIRE_SECURITY_USERNAME_PROPERTY);
        }

        protected String getPassword() {
            return this.environment.getProperty(HttpBasicAuthenticationSecurityConfiguration.SPRING_DATA_GEMFIRE_SECURITY_PASSWORD_PROPERTY);
        }

        public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
            if (this.isAuthenticationEnabled()) {
                HttpHeaders requestHeaders = request.getHeaders();
                requestHeaders.add("security-username", this.getUsername());
                requestHeaders.add("security-password", this.getPassword());
            }
            return execution.execute(request, body);
        }
    }
}

