/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.boot.autoconfigure.support;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.cache.CacheStatistics;
import org.apache.geode.cache.Region;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.geode.pdx.PdxInstanceWrapper;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

@Aspect
public class PdxInstanceWrapperRegionAspect {
    private static Collection<?> asCollection(Object value) {
        return value instanceof Collection ? (Collection)value : Collections.emptyList();
    }

    private static Map<?, ?> asMap(Object value) {
        return value instanceof Map ? (Map)value : Collections.emptyMap();
    }

    @Pointcut(value="target(org.apache.geode.cache.Region)")
    private void regionPointcut() {
    }

    @Pointcut(value="execution(* org.apache.geode.cache.Region.get(..))")
    private void regionGetPointcut() {
    }

    @Pointcut(value="execution(* org.apache.geode.cache.Region.getAll(..))")
    private void regionGetAllPointcut() {
    }

    @Pointcut(value="execution(* org.apache.geode.cache.Region.getEntry(..))")
    private void regionGetEntryPointcut() {
    }

    @Pointcut(value="execution(* org.apache.geode.cache.Region.selectValue(..))")
    private void regionSelectValuePointcut() {
    }

    @Pointcut(value="execution(* org.apache.geode.cache.Region.values())")
    private void regionValuesPointcut() {
    }

    @Around(value="regionPointcut() && regionGetPointcut()")
    public Object regionGetAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        return PdxInstanceWrapper.from((Object)joinPoint.proceed());
    }

    @Around(value="regionPointcut() && regionGetAllPointcut()")
    public Object regionGetAllAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        return PdxInstanceWrapperRegionAspect.asMap(joinPoint.proceed()).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mapEntry -> PdxInstanceWrapper.from(mapEntry.getValue())));
    }

    @Around(value="regionPointcut() && regionGetEntryPointcut()")
    public Object regionGetEntryAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        return RegionEntryWrapper.from(joinPoint.proceed());
    }

    @Around(value="regionPointcut() && regionSelectValuePointcut()")
    public Object regionSelectValueAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        return PdxInstanceWrapper.from((Object)joinPoint.proceed());
    }

    @Around(value="regionPointcut() && regionValuesPointcut()")
    public Object regionValuesAdvice(ProceedingJoinPoint joinPoint) throws Throwable {
        return PdxInstanceWrapperRegionAspect.asCollection(joinPoint.proceed()).stream().map(PdxInstanceWrapper::from).collect(Collectors.toList());
    }

    public static class RegionEntryWrapper<K, V>
    implements Region.Entry<K, V> {
        private final Region.Entry<K, V> delegate;

        public static <T, K, V> T from(T value) {
            return (T)(value instanceof Region.Entry ? new RegionEntryWrapper<K, V>((Region.Entry)value) : value);
        }

        protected RegionEntryWrapper(@NonNull Region.Entry<K, V> regionEntry) {
            Assert.notNull(regionEntry, (String)"Region.Entry must not be null");
            this.delegate = regionEntry;
        }

        @NonNull
        protected Region.Entry<K, V> getDelegate() {
            return this.delegate;
        }

        public boolean isDestroyed() {
            return this.getDelegate().isDestroyed();
        }

        public boolean isLocal() {
            return this.getDelegate().isLocal();
        }

        public K getKey() {
            return (K)this.getDelegate().getKey();
        }

        public Region<K, V> getRegion() {
            return this.getDelegate().getRegion();
        }

        public CacheStatistics getStatistics() {
            return this.getDelegate().getStatistics();
        }

        public Object setUserAttribute(Object userAttribute) {
            return this.getDelegate().setUserAttribute(userAttribute);
        }

        public Object getUserAttribute() {
            return this.getDelegate().getUserAttribute();
        }

        public V setValue(V value) {
            return (V)this.getDelegate().setValue(value);
        }

        public V getValue() {
            return (V)PdxInstanceWrapper.from((Object)this.getDelegate().getValue());
        }
    }
}

