/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.logging.slf4j.logback;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CompositeAppender<T>
extends AppenderBase<T> {
    protected static final String DEFAULT_NAME = "composite";
    private final Appender<T> one;
    private final Appender<T> two;

    public static <T> Appender<T> compose(Appender<T> one, Appender<T> two) {
        return one == null ? two : (two == null ? one : new CompositeAppender<T>(one, two));
    }

    public static <T> Appender<T> compose(Appender<T> ... appenders) {
        List<Appender<T>> resolvedAppenders = appenders != null ? Arrays.asList(appenders) : Collections.emptyList();
        return CompositeAppender.compose(resolvedAppenders);
    }

    public static <T> Appender<T> compose(Iterable<Appender<T>> appenders) {
        Appender<T> currentAppender = null;
        appenders = appenders != null ? appenders : Collections::emptyIterator;
        for (Appender<T> appender : appenders) {
            currentAppender = CompositeAppender.compose(currentAppender, appender);
        }
        return currentAppender;
    }

    private CompositeAppender(Appender<T> one, Appender<T> two) {
        this.one = one;
        this.two = two;
        this.name = DEFAULT_NAME;
        this.started = true;
    }

    protected Appender<T> getAppenderOne() {
        return this.one;
    }

    protected Appender<T> getAppenderTwo() {
        return this.two;
    }

    public void setContext(Context context) {
        super.setContext(context);
        this.getAppenderOne().setContext(context);
        this.getAppenderTwo().setContext(context);
    }

    public Context getContext() {
        Context context = super.getContext();
        context = context != null ? context : this.getAppenderOne().getContext();
        context = context != null ? context : this.getAppenderTwo().getContext();
        return context;
    }

    protected void append(T eventObject) {
        this.getAppenderOne().doAppend(eventObject);
        this.getAppenderTwo().doAppend(eventObject);
    }
}

