/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.logging.slf4j.logback;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.helpers.NOPAppender;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class DelegatingAppender<T>
extends AppenderBase<T> {
    protected static final Appender DEFAULT_APPENDER = new NOPAppender();
    protected static final String DEFAULT_NAME = "delegate";
    private volatile Appender<T> appender;

    public DelegatingAppender() {
        Optional.ofNullable(LoggerFactory.getILoggerFactory()).filter(it -> Objects.isNull(DEFAULT_APPENDER.getContext())).filter(Context.class::isInstance).map(Context.class::cast).ifPresent(arg_0 -> ((Appender)DEFAULT_APPENDER).setContext(arg_0));
        this.name = DEFAULT_NAME;
    }

    public void setAppender(Appender<T> appender) {
        this.appender = appender;
    }

    protected Appender<T> getAppender() {
        return Optional.ofNullable(this.appender).orElse(DEFAULT_APPENDER);
    }

    protected void append(T eventObject) {
        this.getAppender().doAppend(eventObject);
    }
}

