/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.logging.slf4j.logback.support;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class LogbackSupport {
    protected static final Function<Logger, Optional<ch.qos.logback.classic.Logger>> slf4jLoggerToLogbackLoggerConverter = logger -> Optional.ofNullable(logger).filter(ch.qos.logback.classic.Logger.class::isInstance).map(ch.qos.logback.classic.Logger.class::cast);
    protected static final String CONSOLE_APPENDER_NAME = "console";
    protected static final String DELEGATE_APPENDER_NAME = "delegate";
    protected static final String ILLEGAL_LOGGER_TYPE_EXCEPTION_MESSAGE = "[%1$s] Logger type [%2$s] is not a Logback Logger";
    protected static final String ROOT_LOGGER_NAME = "ROOT";
    protected static final String SPRING_BOOT_LOGGING_SYSTEM_CLASS_NAME = "org.springframework.boot.logging.LoggingSystem";
    protected static final String UNRESOLVABLE_APPENDER_EXCEPTION_MESSAGE = "Could not resolve Appender with name [%1$s] as type [%2$s] from Logger [%3$s]";

    public static void suppressSpringBootLogbackInitialization() {
        LogbackSupport.requireLoggerContext().putObject(SPRING_BOOT_LOGGING_SYSTEM_CLASS_NAME, new Object());
    }

    public static void resetLogback() {
        try {
            Method loggerFactoryReset = LoggerFactory.class.getDeclaredMethod("reset", new Class[0]);
            loggerFactoryReset.setAccessible(true);
            loggerFactoryReset.invoke(null, new Object[0]);
            Method staticLoggerBinderReset = StaticLoggerBinder.class.getDeclaredMethod("reset", new Class[0]);
            staticLoggerBinderReset.setAccessible(true);
            staticLoggerBinderReset.invoke(null, new Object[0]);
        }
        catch (Throwable cause) {
            throw new IllegalStateException("Failed to reset Logback", cause);
        }
    }

    public static Optional<LoggerContext> resolveLoggerContext() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        LoggerContext resolvedLoggerContext = loggerFactory instanceof LoggerContext ? (LoggerContext)loggerFactory : null;
        return Optional.ofNullable(resolvedLoggerContext);
    }

    public static LoggerContext requireLoggerContext() {
        return LogbackSupport.resolveLoggerContext().orElseThrow(() -> new IllegalStateException("LoggerContext is required"));
    }

    public static Optional<Logger> resolveRootLogger() {
        return Optional.ofNullable(LoggerFactory.getLogger((String)ROOT_LOGGER_NAME));
    }

    public static ch.qos.logback.classic.Logger requireLogbackRootLogger() {
        return LogbackSupport.resolveRootLogger().filter(ch.qos.logback.classic.Logger.class::isInstance).map(ch.qos.logback.classic.Logger.class::cast).orElseThrow(() -> new IllegalStateException(String.format(ILLEGAL_LOGGER_TYPE_EXCEPTION_MESSAGE, ROOT_LOGGER_NAME, LogbackSupport.nullSafeTypeName(LogbackSupport.resolveRootLogger()))));
    }

    public static <E, T extends Appender<E>> Optional<T> resolveAppender(ch.qos.logback.classic.Logger logger, String appenderName, Class<T> appenderType) {
        appenderType = LogbackSupport.nullSafeAppenderType(appenderType);
        return Optional.ofNullable(logger).map(it -> it.getAppender(appenderName)).filter(appenderType::isInstance).map(appenderType::cast);
    }

    public static <E, T extends Appender<E>> T requireAppender(ch.qos.logback.classic.Logger logger, String appenderName, Class<T> appenderType) {
        return (T)((Appender)LogbackSupport.resolveAppender(logger, appenderName, appenderType).orElseThrow(() -> new IllegalStateException(String.format(UNRESOLVABLE_APPENDER_EXCEPTION_MESSAGE, appenderName, LogbackSupport.nullSafeTypeName(appenderType), LogbackSupport.nullSafeLoggerName((Logger)logger)))));
    }

    private static <E, T extends Appender<E>> Class<T> nullSafeAppenderType(Class<T> appenderType) {
        return appenderType != null ? appenderType : Appender.class;
    }

    public static boolean addAppender(ch.qos.logback.classic.Logger logger, Appender<ILoggingEvent> appender) {
        return Optional.ofNullable(logger).filter(it -> Objects.nonNull(appender)).map(it -> {
            it.addAppender(appender);
            return logger.getAppender(appender.getName());
        }).isPresent();
    }

    public static boolean removeAppender(ch.qos.logback.classic.Logger logger, String appenderName) {
        return Optional.ofNullable(logger).map(it -> it.getAppender(appenderName)).filter(appender -> appender.getName().equals(appenderName)).map(appender -> {
            appender.stop();
            return appender;
        }).map(appender -> logger.detachAppender(appender)).orElse(false);
    }

    public static boolean removeConsoleAppender(ch.qos.logback.classic.Logger logger) {
        return LogbackSupport.removeAppender(logger, CONSOLE_APPENDER_NAME);
    }

    public static boolean removeDelegateAppender(ch.qos.logback.classic.Logger logger) {
        return LogbackSupport.removeAppender(logger, DELEGATE_APPENDER_NAME);
    }

    public static Optional<ch.qos.logback.classic.Logger> toLogbackLogger(Logger logger) {
        return slf4jLoggerToLogbackLoggerConverter.apply(logger);
    }

    private static String nullSafeLoggerName(Logger logger) {
        return logger != null ? logger.getName() : null;
    }

    private static Class<?> nullSafeType(Object obj) {
        return obj != null ? obj.getClass() : null;
    }

    private static String nullSafeTypeName(Class<?> type) {
        return type != null ? type.getName() : null;
    }

    private static String nullSafeTypeName(Object obj) {
        return LogbackSupport.nullSafeTypeName(LogbackSupport.nullSafeType(obj));
    }

    private static String nullSafeTypeSimpleName(Class<?> type) {
        return type != null ? type.getSimpleName() : null;
    }

    private static String nullSafeTypeSimpleName(Object obj) {
        return LogbackSupport.nullSafeTypeSimpleName(LogbackSupport.nullSafeType(obj));
    }
}

