/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.logging.slf4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.geode.logging.slf4j.logback.CompositeAppender;
import org.springframework.geode.logging.slf4j.logback.DelegatingAppender;
import org.springframework.geode.logging.slf4j.logback.support.LogbackSupport;

public class StringAppender
extends AppenderBase<ILoggingEvent> {
    protected static final String DEFAULT_NAME = "string";
    protected static final String NEWLINE = "\n";
    private final StringAppenderWrapper stringAppenderWrapper;

    protected StringAppender(StringAppenderWrapper stringAppenderWrapper) {
        if (stringAppenderWrapper == null) {
            throw new IllegalArgumentException("StringAppenderWrapper must not be null");
        }
        this.stringAppenderWrapper = stringAppenderWrapper;
    }

    public String getLogOutput() {
        return this.getStringAppenderWrapper().toString();
    }

    protected StringAppenderWrapper getStringAppenderWrapper() {
        return this.stringAppenderWrapper;
    }

    protected void append(ILoggingEvent loggingEvent) {
        Optional.ofNullable(loggingEvent).map(event -> this.preProcessLogMessage(this.toString((ILoggingEvent)event))).filter(this::isValidLogMessage).ifPresent(this.getStringAppenderWrapper()::append);
    }

    protected boolean isValidLogMessage(String message) {
        return message != null && !message.isEmpty();
    }

    protected String preProcessLogMessage(String message) {
        return message != null ? message.trim() : null;
    }

    protected String toString(ILoggingEvent loggingEvent) {
        return loggingEvent != null ? loggingEvent.getFormattedMessage() : null;
    }

    public static class Builder {
        private static final boolean DEFAULT_REPLACE = false;
        private boolean replace = false;
        private boolean useSynchronization = false;
        private Context context;
        private DelegatingAppender delegate;
        private ch.qos.logback.classic.Logger logger;
        private String name;

        public Builder applyTo(DelegatingAppender<?> delegate) {
            return this.applyTo(delegate, false);
        }

        public Builder applyTo(DelegatingAppender<?> delegate, boolean replace) {
            this.delegate = delegate;
            this.replace = replace;
            return this;
        }

        public Builder applyTo(Logger logger) {
            return LogbackSupport.toLogbackLogger(logger).map(this::applyTo).orElse(this);
        }

        public Builder applyTo(ch.qos.logback.classic.Logger logger) {
            this.logger = logger;
            return this;
        }

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder useSynchronization() {
            this.useSynchronization = true;
            return this;
        }

        private Optional<DelegatingAppender> getDelegate() {
            return Optional.ofNullable(this.delegate);
        }

        private Optional<ch.qos.logback.classic.Logger> getLogger() {
            return Optional.ofNullable(this.logger);
        }

        private Context resolveContext() {
            return this.context != null ? this.context : (Context)Optional.ofNullable(LoggerFactory.getILoggerFactory()).filter(Context.class::isInstance).map(Context.class::cast).orElse(null);
        }

        private String resolveName() {
            return this.name != null && !this.name.trim().isEmpty() ? this.name : StringAppender.DEFAULT_NAME;
        }

        private StringAppenderWrapper resolveStringAppenderWrapper() {
            return this.useSynchronization ? StringBufferAppenderWrapper.create() : StringBuilderAppenderWrapper.create();
        }

        public StringAppender build() {
            StringAppender stringAppender = new StringAppender(this.resolveStringAppenderWrapper());
            stringAppender.setContext(this.resolveContext());
            stringAppender.setName(this.resolveName());
            this.getDelegate().ifPresent(delegate -> {
                Appender appender = this.replace ? stringAppender : CompositeAppender.compose(delegate.getAppender(), stringAppender);
                delegate.setAppender(appender);
            });
            this.getLogger().ifPresent(logger -> logger.addAppender((Appender)stringAppender));
            return stringAppender;
        }

        public StringAppender buildAndStart() {
            StringAppender stringAppender = this.build();
            stringAppender.start();
            return stringAppender;
        }
    }

    protected static class StringBuilderAppenderWrapper
    implements StringAppenderWrapper {
        private final StringBuilder stringBuilder = new StringBuilder();

        protected StringBuilderAppenderWrapper() {
        }

        protected static StringBuilderAppenderWrapper create() {
            return new StringBuilderAppenderWrapper();
        }

        @Override
        public void append(CharSequence charSequence) {
            this.stringBuilder.append(charSequence);
            this.stringBuilder.append(StringAppender.NEWLINE);
        }

        @Override
        public void clear() {
            this.stringBuilder.delete(0, this.stringBuilder.length());
        }

        public String toString() {
            return this.stringBuilder.toString();
        }
    }

    protected static class StringBufferAppenderWrapper
    implements StringAppenderWrapper {
        private final StringBuffer stringBuffer = new StringBuffer();

        protected StringBufferAppenderWrapper() {
        }

        protected static StringBufferAppenderWrapper create() {
            return new StringBufferAppenderWrapper();
        }

        @Override
        public void append(CharSequence charSequence) {
            this.stringBuffer.append(charSequence);
            this.stringBuffer.append(StringAppender.NEWLINE);
        }

        @Override
        public void clear() {
            this.stringBuffer.delete(0, this.stringBuffer.length());
        }

        public String toString() {
            return this.stringBuffer.toString();
        }
    }

    @FunctionalInterface
    static interface StringAppenderWrapper {
        public void append(CharSequence var1);

        default public void clear() {
        }
    }
}

