/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.cache;

import java.util.function.Supplier;
import org.apache.geode.cache.CacheLoaderException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.cache.LoaderHelper;
import org.springframework.data.repository.CrudRepository;
import org.springframework.geode.cache.support.RepositoryCacheLoaderWriterSupport;

public class RepositoryCacheLoader<T, ID>
extends RepositoryCacheLoaderWriterSupport<T, ID> {
    protected static final String CACHE_LOAD_EXCEPTION_MESSAGE = "Error while loading Entity [%s] with Repository [%s]";

    public RepositoryCacheLoader(CrudRepository<T, ID> repository) {
        super(repository);
    }

    @Override
    public T load(LoaderHelper<ID, T> helper) throws CacheLoaderException {
        try {
            return this.getRepository().findById(helper.getKey()).orElse(null);
        }
        catch (Exception cause) {
            throw this.newCacheRuntimeException(() -> String.format(CACHE_LOAD_EXCEPTION_MESSAGE, helper.getKey(), this.getRepository().getClass().getName()), cause);
        }
    }

    @Override
    protected CacheRuntimeException newCacheRuntimeException(Supplier<String> messageSupplier, Throwable cause) {
        return new CacheLoaderException(messageSupplier.get(), cause);
    }
}

