/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.geode.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.geode.cache.Region;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.geode.data.CacheDataImporterExporter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractCacheDataImporterExporter
implements ApplicationContextAware,
CacheDataImporterExporter,
EnvironmentAware {
    protected static final boolean DEFAULT_CACHE_DATA_EXPORT_ENABLED = false;
    protected static final boolean DEFAULT_CACHE_DATA_IMPORT_ENABLED = true;
    protected static final String CACHE_DATA_EXPORT_ENABLED_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.export.enabled";
    protected static final String CACHE_DATA_IMPORT_ACTIVE_PROFILES_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.import.active-profiles";
    protected static final String CACHE_DATA_IMPORT_ENABLED_PROPERTY_NAME = "spring.boot.data.gemfire.cache.data.import.enabled";
    protected static final String DEFAULT_CACHE_DATA_IMPORT_ACTIVE_PROFILES = "";
    private static final String RESERVED_DEFAULT_PROFILE_NAME = "default";
    private ApplicationContext applicationContext;
    private Environment environment;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Predicate<Region<?, ?>> regionPredicate = this.newRegionPredicate();

    private Predicate<Region<?, ?>> newRegionPredicate() {
        return region -> true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    protected Optional<ApplicationContext> getApplicationContext() {
        return Optional.ofNullable(this.applicationContext);
    }

    protected ApplicationContext requireApplicationContext() {
        return this.getApplicationContext().orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"ApplicationContext was not configured", (Object[])new Object[0]));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    protected Optional<Environment> getEnvironment() {
        return Optional.ofNullable(this.environment);
    }

    protected Environment requireEnvironment() {
        return this.getEnvironment().orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException((String)"Environment was not configured", (Object[])new Object[0]));
    }

    protected Logger getLogger() {
        return this.logger;
    }

    @NonNull
    protected Predicate<Region<?, ?>> getRegionPredicate() {
        return Optional.ofNullable(this.regionPredicate).orElseGet(this::newRegionPredicate);
    }

    protected boolean isExportEnabled(@Nullable Environment environment) {
        return environment != null && Boolean.TRUE.equals(environment.getProperty(CACHE_DATA_EXPORT_ENABLED_PROPERTY_NAME, Boolean.class, (Object)false));
    }

    @Override
    @NonNull
    public Region exportFrom(@NonNull Region region) {
        Assert.notNull((Object)region, (String)"Region must not be null");
        boolean exportEnabled = this.getEnvironment().filter(this::isExportEnabled).filter(environment -> this.getRegionPredicate().test(region)).isPresent();
        return exportEnabled ? this.doExportFrom(region) : region;
    }

    @NonNull
    protected abstract Region doExportFrom(@NonNull Region var1);

    protected boolean isImportEnabled(@Nullable Environment environment) {
        return environment != null && Boolean.TRUE.equals(environment.getProperty(CACHE_DATA_IMPORT_ENABLED_PROPERTY_NAME, Boolean.class, (Object)true));
    }

    protected boolean isImportProfilesActive(@NonNull Environment environment) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        boolean importProfilesActive = true;
        String cacheDataImportActiveProfiles = environment.getProperty(CACHE_DATA_IMPORT_ACTIVE_PROFILES_PROPERTY_NAME, DEFAULT_CACHE_DATA_IMPORT_ACTIVE_PROFILES);
        Set<String> cacheDataImportProfiles = this.commaDelimitedStringToSet(cacheDataImportActiveProfiles);
        if (!cacheDataImportProfiles.isEmpty()) {
            Set<String> configuredProfiles = this.useDefaultProfilesIfEmpty(environment, this.getActiveProfiles(environment));
            importProfilesActive = CollectionUtils.containsAny(configuredProfiles, cacheDataImportProfiles);
        }
        return importProfilesActive;
    }

    @Override
    @NonNull
    public Region importInto(@NonNull Region region) {
        Assert.notNull((Object)region, (String)"Region must not be null");
        boolean importEnabled = this.getEnvironment().filter(this::isImportEnabled).filter(this::isImportProfilesActive).filter(environment -> this.getRegionPredicate().test(region)).isPresent();
        return importEnabled ? this.doImportInto(region) : region;
    }

    @NonNull
    protected abstract Region doImportInto(@NonNull Region var1);

    @NonNull
    Set<String> commaDelimitedStringToSet(@Nullable String commaDelimitedString) {
        return StringUtils.hasText((String)commaDelimitedString) ? Arrays.stream(commaDelimitedString.split(",")).map(String::trim).filter(StringUtils::hasText).collect(Collectors.toSet()) : Collections.emptySet();
    }

    @NonNull
    Set<String> getActiveProfiles(@NonNull Environment environment) {
        return environment != null ? AbstractCacheDataImporterExporter.toSet(environment.getActiveProfiles(), String.class) : Collections.emptySet();
    }

    @NonNull
    Set<String> useDefaultProfilesIfEmpty(@NonNull Environment environment, @Nullable Set<String> activeProfiles) {
        Set<String> resolvedProfiles = CollectionUtils.nullSafeSet(activeProfiles).stream().filter(StringUtils::hasText).collect(Collectors.toSet());
        if (resolvedProfiles.isEmpty()) {
            Set<String> defaultProfiles;
            Set<String> set = defaultProfiles = environment != null ? AbstractCacheDataImporterExporter.toSet(environment.getDefaultProfiles(), String.class).stream().filter(StringUtils::hasText).collect(Collectors.toSet()) : Collections.emptySet();
            if (this.isNotDefaultProfileOnlySet(defaultProfiles)) {
                resolvedProfiles = defaultProfiles;
            }
        }
        return resolvedProfiles;
    }

    boolean isNotDefaultProfileOnlySet(@Nullable Set<String> profiles) {
        return Objects.nonNull(profiles) && !profiles.isEmpty() && !Collections.singleton(RESERVED_DEFAULT_PROFILE_NAME).containsAll(profiles);
    }

    @NonNull
    private static <T> Set<T> toSet(@Nullable T[] array, @NonNull Class<T> type) {
        return CollectionUtils.asSet((Object[])ArrayUtils.nullSafeArray((Object[])array, type));
    }
}

