/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.DeliveryAttemptAware;
import org.springframework.kafka.listener.FailedRecordTracker;
import org.springframework.kafka.listener.KafkaExceptionLogLevelAware;
import org.springframework.kafka.listener.ListenerUtils;
import org.springframework.kafka.support.TopicPartitionOffset;
import org.springframework.kafka.support.converter.ConversionException;
import org.springframework.kafka.support.serializer.DeserializationException;
import org.springframework.lang.Nullable;
import org.springframework.messaging.converter.MessageConversionException;
import org.springframework.messaging.handler.invocation.MethodArgumentResolutionException;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;

public abstract class FailedRecordProcessor
extends KafkaExceptionLogLevelAware
implements DeliveryAttemptAware {
    private static final BiPredicate<ConsumerRecord<?, ?>, Exception> ALWAYS_SKIP_PREDICATE = (r, e) -> true;
    private static final BiPredicate<ConsumerRecord<?, ?>, Exception> NEVER_SKIP_PREDICATE = (r, e) -> false;
    protected final LogAccessor logger = new LogAccessor(LogFactory.getLog(this.getClass()));
    private final FailedRecordTracker failureTracker;
    private BinaryExceptionClassifier classifier;
    private boolean commitRecovered;

    protected FailedRecordProcessor(@Nullable BiConsumer<ConsumerRecord<?, ?>, Exception> recoverer, BackOff backOff) {
        this.failureTracker = new FailedRecordTracker(recoverer, backOff, this.logger);
        this.classifier = FailedRecordProcessor.configureDefaultClassifier();
    }

    protected BinaryExceptionClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifications(Map<Class<? extends Throwable>, Boolean> classifications, boolean defaultValue) {
        Assert.notNull(classifications, (String)"'classifications' + cannot be null");
        this.classifier = new ExtendedBinaryExceptionClassifier(classifications, defaultValue);
    }

    protected boolean isCommitRecovered() {
        return this.commitRecovered;
    }

    public void setCommitRecovered(boolean commitRecovered) {
        this.commitRecovered = commitRecovered;
    }

    public void setResetStateOnRecoveryFailure(boolean resetStateOnRecoveryFailure) {
        this.failureTracker.setResetStateOnRecoveryFailure(resetStateOnRecoveryFailure);
    }

    @Override
    public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        return this.failureTracker.deliveryAttempt(topicPartitionOffset);
    }

    public void addNotRetryableException(Class<? extends Exception> exceptionType) {
        Assert.isTrue((boolean)(this.classifier instanceof ExtendedBinaryExceptionClassifier), (String)"Cannot add exception types to a supplied classifier");
        ((ExtendedBinaryExceptionClassifier)this.classifier).getClassified().put(exceptionType, false);
    }

    public boolean removeNotRetryableException(Class<? extends Exception> exceptionType) {
        Assert.isTrue((boolean)(this.classifier instanceof ExtendedBinaryExceptionClassifier), (String)"Cannot remove exception types from a supplied classifier");
        return ((ExtendedBinaryExceptionClassifier)this.classifier).getClassified().remove(exceptionType);
    }

    protected BiPredicate<ConsumerRecord<?, ?>, Exception> getSkipPredicate(List<ConsumerRecord<?, ?>> records, Exception thrownException) {
        if (this.getClassifier().classify((Throwable)thrownException).booleanValue()) {
            return this.failureTracker::skip;
        }
        try {
            this.failureTracker.getRecoverer().accept(records.get(0), thrownException);
        }
        catch (Exception ex) {
            if (records.size() > 0) {
                this.logger.error((Throwable)ex, () -> "Recovery of record (" + ListenerUtils.recordToString((ConsumerRecord)records.get(0)) + ") failed");
            }
            return NEVER_SKIP_PREDICATE;
        }
        return ALWAYS_SKIP_PREDICATE;
    }

    public void clearThreadState() {
        this.failureTracker.clearThreadState();
    }

    private static BinaryExceptionClassifier configureDefaultClassifier() {
        HashMap<Class<? extends Throwable>, Boolean> classified = new HashMap<Class<? extends Throwable>, Boolean>();
        classified.put(DeserializationException.class, false);
        classified.put(MessageConversionException.class, false);
        classified.put(ConversionException.class, false);
        classified.put(MethodArgumentResolutionException.class, false);
        classified.put(NoSuchMethodException.class, false);
        classified.put(ClassCastException.class, false);
        return new ExtendedBinaryExceptionClassifier(classified, true);
    }

    private static final class ExtendedBinaryExceptionClassifier
    extends BinaryExceptionClassifier {
        ExtendedBinaryExceptionClassifier(Map<Class<? extends Throwable>, Boolean> typeMap, boolean defaultValue) {
            super(typeMap, defaultValue);
            this.setTraverseCauses(true);
        }

        protected Map<Class<? extends Throwable>, Boolean> getClassified() {
            return super.getClassified();
        }
    }
}

