/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.samples.odm.dao;

import java.util.List;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.ldap.samples.plain.dao.PersonDao;
import org.springframework.ldap.samples.plain.domain.Person;
import org.springframework.ldap.support.LdapNameBuilder;

public class OdmPersonDaoImpl
implements PersonDao {
    private LdapTemplate ldapTemplate;

    @Override
    public void create(Person person) {
        this.ldapTemplate.create((Object)person);
    }

    @Override
    public void update(Person person) {
        this.ldapTemplate.update((Object)person);
    }

    @Override
    public void delete(Person person) {
        this.ldapTemplate.delete(this.ldapTemplate.findByDn((Name)this.buildDn(person), Person.class));
    }

    @Override
    public List<String> getAllPersonNames() {
        return this.ldapTemplate.search((LdapQuery)LdapQueryBuilder.query().attributes(new String[]{"cn"}).where("objectclass").is("person"), (AttributesMapper)new AttributesMapper<String>(){

            public String mapFromAttributes(Attributes attrs) throws NamingException {
                return attrs.get("cn").get().toString();
            }
        });
    }

    @Override
    public List<Person> findAll() {
        return this.ldapTemplate.findAll(Person.class);
    }

    @Override
    public Person findByPrimaryKey(String country, String company, String fullname) {
        LdapName dn = this.buildDn(country, company, fullname);
        Person person = (Person)this.ldapTemplate.findByDn((Name)dn, Person.class);
        return person;
    }

    private LdapName buildDn(Person person) {
        return this.buildDn(person.getCountry(), person.getCompany(), person.getFullName());
    }

    private LdapName buildDn(String country, String company, String fullname) {
        return LdapNameBuilder.newInstance().add("c", (Object)country).add("ou", (Object)company).add("cn", (Object)fullname).build();
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }
}

