/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.odm.tools;

import java.util.HashMap;
import java.util.Map;

final class SyntaxToJavaClass {
    private final Map<String, ClassInfo> mapSyntaxToClassInfo = new HashMap<String, ClassInfo>();

    public SyntaxToJavaClass(Map<String, String> mapSyntaxToClass) {
        for (Map.Entry<String, String> syntaxAndClass : mapSyntaxToClass.entrySet()) {
            String fullClassName = syntaxAndClass.getValue().trim();
            String packageName = null;
            String className = null;
            int lastDotIndex = fullClassName.lastIndexOf(46);
            if (lastDotIndex != -1) {
                className = fullClassName.substring(lastDotIndex + 1);
                packageName = fullClassName.substring(0, lastDotIndex);
            } else {
                className = fullClassName;
            }
            this.mapSyntaxToClassInfo.put(syntaxAndClass.getKey(), new ClassInfo(className, packageName));
        }
    }

    public ClassInfo getClassInfo(String syntax) {
        return this.mapSyntaxToClassInfo.get(syntax);
    }

    public static final class ClassInfo {
        private final String className;
        private final String packageName;

        private ClassInfo(String className, String packageName) {
            this.className = className;
            this.packageName = packageName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public String getFullClassName() {
            StringBuilder result = new StringBuilder();
            if (this.packageName != null) {
                result.append(this.packageName).append(".").append(this.className);
            } else {
                result.append(this.className);
            }
            return result.toString();
        }
    }
}

